/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.DomainId;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetEgressNodeInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetEgressNodeInputBuilder
implements Builder<SetEgressNodeInput> {
    private DomainId _domainId;
    private IpAddress _dstGroup;
    private BfrId _egressBfrId;
    private String _egressNode;
    private Short _groupWildcard;
    private BfrId _ingressBfrId;
    private String _ingressNode;
    private String _name;
    private Short _sourceWildcard;
    private IpAddress _srcIp;
    private SubDomainId _subDomainId;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>> augmentation = Collections.emptyMap();

    public SetEgressNodeInputBuilder() {
    }

    public SetEgressNodeInputBuilder(Channel arg) {
        this._name = arg.getName();
        this._srcIp = arg.getSrcIp();
        this._dstGroup = arg.getDstGroup();
        this._domainId = arg.getDomainId();
        this._subDomainId = arg.getSubDomainId();
        this._sourceWildcard = arg.getSourceWildcard();
        this._groupWildcard = arg.getGroupWildcard();
    }

    public SetEgressNodeInputBuilder(SetEgressNodeInput base) {
        AugmentationHolder casted;
        this._domainId = base.getDomainId();
        this._dstGroup = base.getDstGroup();
        this._egressBfrId = base.getEgressBfrId();
        this._egressNode = base.getEgressNode();
        this._groupWildcard = base.getGroupWildcard();
        this._ingressBfrId = base.getIngressBfrId();
        this._ingressNode = base.getIngressNode();
        this._name = base.getName();
        this._sourceWildcard = base.getSourceWildcard();
        this._srcIp = base.getSrcIp();
        this._subDomainId = base.getSubDomainId();
        this._writeType = base.getWriteType();
        if (base instanceof SetEgressNodeInputImpl) {
            SetEgressNodeInputImpl impl = (SetEgressNodeInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Channel) {
            this._name = ((Channel)arg).getName();
            this._srcIp = ((Channel)arg).getSrcIp();
            this._dstGroup = ((Channel)arg).getDstGroup();
            this._domainId = ((Channel)arg).getDomainId();
            this._subDomainId = ((Channel)arg).getSubDomainId();
            this._sourceWildcard = ((Channel)arg).getSourceWildcard();
            this._groupWildcard = ((Channel)arg).getGroupWildcard();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel] \nbut was: " + arg);
        }
    }

    public DomainId getDomainId() {
        return this._domainId;
    }

    public IpAddress getDstGroup() {
        return this._dstGroup;
    }

    public BfrId getEgressBfrId() {
        return this._egressBfrId;
    }

    public String getEgressNode() {
        return this._egressNode;
    }

    public Short getGroupWildcard() {
        return this._groupWildcard;
    }

    public BfrId getIngressBfrId() {
        return this._ingressBfrId;
    }

    public String getIngressNode() {
        return this._ingressNode;
    }

    public String getName() {
        return this._name;
    }

    public Short getSourceWildcard() {
        return this._sourceWildcard;
    }

    public IpAddress getSrcIp() {
        return this._srcIp;
    }

    public SubDomainId getSubDomainId() {
        return this._subDomainId;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetEgressNodeInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetEgressNodeInputBuilder setDomainId(DomainId value) {
        this._domainId = value;
        return this;
    }

    public SetEgressNodeInputBuilder setDstGroup(IpAddress value) {
        this._dstGroup = value;
        return this;
    }

    public SetEgressNodeInputBuilder setEgressBfrId(BfrId value) {
        this._egressBfrId = value;
        return this;
    }

    public SetEgressNodeInputBuilder setEgressNode(String value) {
        this._egressNode = value;
        return this;
    }

    private static void checkGroupWildcardRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SetEgressNodeInputBuilder setGroupWildcard(Short value) {
        if (value != null) {
            SetEgressNodeInputBuilder.checkGroupWildcardRange(value);
        }
        this._groupWildcard = value;
        return this;
    }

    public SetEgressNodeInputBuilder setIngressBfrId(BfrId value) {
        this._ingressBfrId = value;
        return this;
    }

    public SetEgressNodeInputBuilder setIngressNode(String value) {
        this._ingressNode = value;
        return this;
    }

    public SetEgressNodeInputBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkSourceWildcardRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SetEgressNodeInputBuilder setSourceWildcard(Short value) {
        if (value != null) {
            SetEgressNodeInputBuilder.checkSourceWildcardRange(value);
        }
        this._sourceWildcard = value;
        return this;
    }

    public SetEgressNodeInputBuilder setSrcIp(IpAddress value) {
        this._srcIp = value;
        return this;
    }

    public SetEgressNodeInputBuilder setSubDomainId(SubDomainId value) {
        this._subDomainId = value;
        return this;
    }

    public SetEgressNodeInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetEgressNodeInputBuilder addAugmentation(Class<? extends Augmentation<SetEgressNodeInput>> augmentationType, Augmentation<SetEgressNodeInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetEgressNodeInputBuilder removeAugmentation(Class<? extends Augmentation<SetEgressNodeInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetEgressNodeInput build() {
        return new SetEgressNodeInputImpl(this);
    }

    private static final class SetEgressNodeInputImpl
    implements SetEgressNodeInput {
        private final DomainId _domainId;
        private final IpAddress _dstGroup;
        private final BfrId _egressBfrId;
        private final String _egressNode;
        private final Short _groupWildcard;
        private final BfrId _ingressBfrId;
        private final String _ingressNode;
        private final String _name;
        private final Short _sourceWildcard;
        private final IpAddress _srcIp;
        private final SubDomainId _subDomainId;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetEgressNodeInput> getImplementedInterface() {
            return SetEgressNodeInput.class;
        }

        private SetEgressNodeInputImpl(SetEgressNodeInputBuilder base) {
            this._domainId = base.getDomainId();
            this._dstGroup = base.getDstGroup();
            this._egressBfrId = base.getEgressBfrId();
            this._egressNode = base.getEgressNode();
            this._groupWildcard = base.getGroupWildcard();
            this._ingressBfrId = base.getIngressBfrId();
            this._ingressNode = base.getIngressNode();
            this._name = base.getName();
            this._sourceWildcard = base.getSourceWildcard();
            this._srcIp = base.getSrcIp();
            this._subDomainId = base.getSubDomainId();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>>(base.augmentation);
                }
            }
        }

        public DomainId getDomainId() {
            return this._domainId;
        }

        public IpAddress getDstGroup() {
            return this._dstGroup;
        }

        @Override
        public BfrId getEgressBfrId() {
            return this._egressBfrId;
        }

        @Override
        public String getEgressNode() {
            return this._egressNode;
        }

        public Short getGroupWildcard() {
            return this._groupWildcard;
        }

        @Override
        public BfrId getIngressBfrId() {
            return this._ingressBfrId;
        }

        @Override
        public String getIngressNode() {
            return this._ingressNode;
        }

        public String getName() {
            return this._name;
        }

        public Short getSourceWildcard() {
            return this._sourceWildcard;
        }

        public IpAddress getSrcIp() {
            return this._srcIp;
        }

        public SubDomainId getSubDomainId() {
            return this._subDomainId;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetEgressNodeInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._domainId);
            result = 31 * result + Objects.hashCode(this._dstGroup);
            result = 31 * result + Objects.hashCode(this._egressBfrId);
            result = 31 * result + Objects.hashCode(this._egressNode);
            result = 31 * result + Objects.hashCode(this._groupWildcard);
            result = 31 * result + Objects.hashCode(this._ingressBfrId);
            result = 31 * result + Objects.hashCode(this._ingressNode);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sourceWildcard);
            result = 31 * result + Objects.hashCode(this._srcIp);
            result = 31 * result + Objects.hashCode(this._subDomainId);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetEgressNodeInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetEgressNodeInput other = (SetEgressNodeInput)obj;
            if (!Objects.equals(this._domainId, other.getDomainId())) {
                return false;
            }
            if (!Objects.equals(this._dstGroup, other.getDstGroup())) {
                return false;
            }
            if (!Objects.equals(this._egressBfrId, other.getEgressBfrId())) {
                return false;
            }
            if (!Objects.equals(this._egressNode, other.getEgressNode())) {
                return false;
            }
            if (!Objects.equals(this._groupWildcard, other.getGroupWildcard())) {
                return false;
            }
            if (!Objects.equals(this._ingressBfrId, other.getIngressBfrId())) {
                return false;
            }
            if (!Objects.equals(this._ingressNode, other.getIngressNode())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sourceWildcard, other.getSourceWildcard())) {
                return false;
            }
            if (!Objects.equals(this._srcIp, other.getSrcIp())) {
                return false;
            }
            if (!Objects.equals(this._subDomainId, other.getSubDomainId())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetEgressNodeInputImpl otherImpl = (SetEgressNodeInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetEgressNodeInput>>, Augmentation<SetEgressNodeInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetEgressNodeInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._domainId != null) {
                builder.append("_domainId=");
                builder.append(this._domainId);
                builder.append(", ");
            }
            if (this._dstGroup != null) {
                builder.append("_dstGroup=");
                builder.append(this._dstGroup);
                builder.append(", ");
            }
            if (this._egressBfrId != null) {
                builder.append("_egressBfrId=");
                builder.append(this._egressBfrId);
                builder.append(", ");
            }
            if (this._egressNode != null) {
                builder.append("_egressNode=");
                builder.append(this._egressNode);
                builder.append(", ");
            }
            if (this._groupWildcard != null) {
                builder.append("_groupWildcard=");
                builder.append(this._groupWildcard);
                builder.append(", ");
            }
            if (this._ingressBfrId != null) {
                builder.append("_ingressBfrId=");
                builder.append(this._ingressBfrId);
                builder.append(", ");
            }
            if (this._ingressNode != null) {
                builder.append("_ingressNode=");
                builder.append(this._ingressNode);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sourceWildcard != null) {
                builder.append("_sourceWildcard=");
                builder.append(this._sourceWildcard);
                builder.append(", ");
            }
            if (this._srcIp != null) {
                builder.append("_srcIp=");
                builder.append(this._srcIp);
                builder.append(", ");
            }
            if (this._subDomainId != null) {
                builder.append("_subDomainId=");
                builder.append(this._subDomainId);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

