/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.te.path.rev170503.TePath;
import org.opendaylight.yang.gen.v1.urn.bier.te.path.rev170503.te.path.Bitstring;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetBierTeBitstringInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.Bsl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.Si;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetBierTeBitstringInputBuilder
implements Builder<SetBierTeBitstringInput> {
    private List<Bitstring> _bitstring;
    private Bsl _bitstringlength;
    private String _nodeName;
    private Long _pathId;
    private Si _si;
    private SubDomainId _subdomainId;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>> augmentation = Collections.emptyMap();

    public SetBierTeBitstringInputBuilder() {
    }

    public SetBierTeBitstringInputBuilder(TePath arg) {
        this._pathId = arg.getPathId();
        this._subdomainId = arg.getSubdomainId();
        this._bitstringlength = arg.getBitstringlength();
        this._si = arg.getSi();
        this._bitstring = arg.getBitstring();
    }

    public SetBierTeBitstringInputBuilder(SetBierTeBitstringInput base) {
        AugmentationHolder casted;
        this._bitstring = base.getBitstring();
        this._bitstringlength = base.getBitstringlength();
        this._nodeName = base.getNodeName();
        this._pathId = base.getPathId();
        this._si = base.getSi();
        this._subdomainId = base.getSubdomainId();
        this._writeType = base.getWriteType();
        if (base instanceof SetBierTeBitstringInputImpl) {
            SetBierTeBitstringInputImpl impl = (SetBierTeBitstringInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TePath) {
            this._pathId = ((TePath)arg).getPathId();
            this._subdomainId = ((TePath)arg).getSubdomainId();
            this._bitstringlength = ((TePath)arg).getBitstringlength();
            this._si = ((TePath)arg).getSi();
            this._bitstring = ((TePath)arg).getBitstring();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.bier.te.path.rev170503.TePath] \nbut was: " + arg);
        }
    }

    public List<Bitstring> getBitstring() {
        return this._bitstring;
    }

    public Bsl getBitstringlength() {
        return this._bitstringlength;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public Long getPathId() {
        return this._pathId;
    }

    public Si getSi() {
        return this._si;
    }

    public SubDomainId getSubdomainId() {
        return this._subdomainId;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetBierTeBitstringInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetBierTeBitstringInputBuilder setBitstring(List<Bitstring> value) {
        this._bitstring = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder setBitstringlength(Bsl value) {
        this._bitstringlength = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SetBierTeBitstringInputBuilder setPathId(Long value) {
        if (value != null) {
            SetBierTeBitstringInputBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder setSi(Si value) {
        this._si = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder setSubdomainId(SubDomainId value) {
        this._subdomainId = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetBierTeBitstringInputBuilder addAugmentation(Class<? extends Augmentation<SetBierTeBitstringInput>> augmentationType, Augmentation<SetBierTeBitstringInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetBierTeBitstringInputBuilder removeAugmentation(Class<? extends Augmentation<SetBierTeBitstringInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetBierTeBitstringInput build() {
        return new SetBierTeBitstringInputImpl(this);
    }

    private static final class SetBierTeBitstringInputImpl
    implements SetBierTeBitstringInput {
        private final List<Bitstring> _bitstring;
        private final Bsl _bitstringlength;
        private final String _nodeName;
        private final Long _pathId;
        private final Si _si;
        private final SubDomainId _subdomainId;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetBierTeBitstringInput> getImplementedInterface() {
            return SetBierTeBitstringInput.class;
        }

        private SetBierTeBitstringInputImpl(SetBierTeBitstringInputBuilder base) {
            this._bitstring = base.getBitstring();
            this._bitstringlength = base.getBitstringlength();
            this._nodeName = base.getNodeName();
            this._pathId = base.getPathId();
            this._si = base.getSi();
            this._subdomainId = base.getSubdomainId();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>>(base.augmentation);
                }
            }
        }

        public List<Bitstring> getBitstring() {
            return this._bitstring;
        }

        public Bsl getBitstringlength() {
            return this._bitstringlength;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        public Long getPathId() {
            return this._pathId;
        }

        public Si getSi() {
            return this._si;
        }

        public SubDomainId getSubdomainId() {
            return this._subdomainId;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetBierTeBitstringInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bitstring);
            result = 31 * result + Objects.hashCode(this._bitstringlength);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._si);
            result = 31 * result + Objects.hashCode(this._subdomainId);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetBierTeBitstringInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetBierTeBitstringInput other = (SetBierTeBitstringInput)obj;
            if (!Objects.equals(this._bitstring, other.getBitstring())) {
                return false;
            }
            if (!Objects.equals(this._bitstringlength, other.getBitstringlength())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._si, other.getSi())) {
                return false;
            }
            if (!Objects.equals(this._subdomainId, other.getSubdomainId())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetBierTeBitstringInputImpl otherImpl = (SetBierTeBitstringInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetBierTeBitstringInput>>, Augmentation<SetBierTeBitstringInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetBierTeBitstringInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bitstring != null) {
                builder.append("_bitstring=");
                builder.append(this._bitstring);
                builder.append(", ");
            }
            if (this._bitstringlength != null) {
                builder.append("_bitstringlength=");
                builder.append(this._bitstringlength);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._si != null) {
                builder.append("_si=");
                builder.append(this._si);
                builder.append(", ");
            }
            if (this._subdomainId != null) {
                builder.append("_subdomainId=");
                builder.append(this._subdomainId);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

