/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.programming.spi;

import com.google.common.base.Preconditions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.instruction.status.changed.Details;

public final class ExecutionResult<T extends Details> {
    private final InstructionStatus status;
    private final T details;

    public ExecutionResult(InstructionStatus status, T details) {
        Preconditions.checkArgument((status == InstructionStatus.Cancelled || status == InstructionStatus.Failed || status == InstructionStatus.Successful ? 1 : 0) != 0, (Object)("Illegal instruction status " + status));
        Preconditions.checkArgument((status != InstructionStatus.Failed || details != null ? 1 : 0) != 0, (Object)"Failed status requires details");
        this.status = status;
        this.details = details;
    }

    public InstructionStatus getStatus() {
        return this.status;
    }

    public T getDetails() {
        return this.details;
    }

    public String toString() {
        return "ExecutionResult [status=" + this.status + ", details=" + this.details + "]";
    }
}

