/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.mp.reach.nlri.AdvertizedRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MpReachNlriBuilder {
    private AdvertizedRoutes _advertizedRoutes;
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    private CNextHop _cNextHop;
    private Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>();

    public MpReachNlriBuilder() {
    }

    public MpReachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MpReachNlriBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (arg instanceof NextHop) {
            this._cNextHop = ((NextHop)arg).getCNextHop();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.NextHop] \nbut was: " + arg);
        }
    }

    public AdvertizedRoutes getAdvertizedRoutes() {
        return this._advertizedRoutes;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public CNextHop getCNextHop() {
        return this._cNextHop;
    }

    public <E extends Augmentation<MpReachNlri>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MpReachNlriBuilder setAdvertizedRoutes(AdvertizedRoutes value) {
        this._advertizedRoutes = value;
        return this;
    }

    public MpReachNlriBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public MpReachNlriBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public MpReachNlriBuilder setCNextHop(CNextHop value) {
        this._cNextHop = value;
        return this;
    }

    public MpReachNlriBuilder addAugmentation(Class<? extends Augmentation<MpReachNlri>> augmentationType, Augmentation<MpReachNlri> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MpReachNlri build() {
        return new MpReachNlriImpl(this);
    }

    private static final class MpReachNlriImpl
    implements MpReachNlri {
        private final AdvertizedRoutes _advertizedRoutes;
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final CNextHop _cNextHop;
        private Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>();

        public Class<MpReachNlri> getImplementedInterface() {
            return MpReachNlri.class;
        }

        private MpReachNlriImpl(MpReachNlriBuilder builder) {
            this._advertizedRoutes = builder.getAdvertizedRoutes();
            this._afi = builder.getAfi();
            this._safi = builder.getSafi();
            this._cNextHop = builder.getCNextHop();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public AdvertizedRoutes getAdvertizedRoutes() {
            return this._advertizedRoutes;
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public CNextHop getCNextHop() {
            return this._cNextHop;
        }

        public <E extends Augmentation<MpReachNlri>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._advertizedRoutes == null ? 0 : this._advertizedRoutes.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._safi == null ? 0 : this._safi.hashCode());
            result = 31 * result + (this._cNextHop == null ? 0 : this._cNextHop.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MpReachNlriImpl other = (MpReachNlriImpl)obj;
            if (this._advertizedRoutes == null ? other._advertizedRoutes != null : !this._advertizedRoutes.equals(other._advertizedRoutes)) {
                return false;
            }
            if (this._afi == null ? other._afi != null : !this._afi.equals(other._afi)) {
                return false;
            }
            if (this._safi == null ? other._safi != null : !this._safi.equals(other._safi)) {
                return false;
            }
            if (this._cNextHop == null ? other._cNextHop != null : !this._cNextHop.equals(other._cNextHop)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MpReachNlri [_advertizedRoutes=");
            builder.append(this._advertizedRoutes);
            builder.append(", _afi=");
            builder.append(this._afi);
            builder.append(", _safi=");
            builder.append(this._safi);
            builder.append(", _cNextHop=");
            builder.append(this._cNextHop);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

