/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Community;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CommunitiesBuilder {
    private AsNumber _asNumber;
    private Integer _semantics;
    private Map<Class<? extends Augmentation<Communities>>, Augmentation<Communities>> augmentation = new HashMap<Class<? extends Augmentation<Communities>>, Augmentation<Communities>>();

    public CommunitiesBuilder() {
    }

    public CommunitiesBuilder(Community arg) {
        this._asNumber = arg.getAsNumber();
        this._semantics = arg.getSemantics();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Community) {
            this._asNumber = ((Community)arg).getAsNumber();
            this._semantics = ((Community)arg).getSemantics();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Community] \nbut was: " + arg);
        }
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public Integer getSemantics() {
        return this._semantics;
    }

    public <E extends Augmentation<Communities>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CommunitiesBuilder setAsNumber(AsNumber value) {
        this._asNumber = value;
        return this;
    }

    public CommunitiesBuilder setSemantics(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._semantics = value;
        return this;
    }

    public CommunitiesBuilder addAugmentation(Class<? extends Augmentation<Communities>> augmentationType, Augmentation<Communities> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Communities build() {
        return new CommunitiesImpl(this);
    }

    private static final class CommunitiesImpl
    implements Communities {
        private final AsNumber _asNumber;
        private final Integer _semantics;
        private Map<Class<? extends Augmentation<Communities>>, Augmentation<Communities>> augmentation = new HashMap<Class<? extends Augmentation<Communities>>, Augmentation<Communities>>();

        public Class<Communities> getImplementedInterface() {
            return Communities.class;
        }

        private CommunitiesImpl(CommunitiesBuilder builder) {
            this._asNumber = builder.getAsNumber();
            this._semantics = builder.getSemantics();
            this.augmentation.putAll(builder.augmentation);
        }

        public AsNumber getAsNumber() {
            return this._asNumber;
        }

        public Integer getSemantics() {
            return this._semantics;
        }

        public <E extends Augmentation<Communities>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._asNumber == null ? 0 : this._asNumber.hashCode());
            result = 31 * result + (this._semantics == null ? 0 : this._semantics.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommunitiesImpl other = (CommunitiesImpl)obj;
            if (this._asNumber == null ? other._asNumber != null : !this._asNumber.equals((Object)other._asNumber)) {
                return false;
            }
            if (this._semantics == null ? other._semantics != null : !this._semantics.equals(other._semantics)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Communities [_asNumber=");
            builder.append(this._asNumber);
            builder.append(", _semantics=");
            builder.append(this._semantics);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

