/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919;

import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.util.ArrayList;

public class ProtocolVersion {
    private final Short _value;

    @ConstructorProperties(value={"value"})
    public ProtocolVersion(Short _value) {
        if (_value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("1"), (Comparable)new Short("7")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)_value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", _value, rangeConstraints));
            }
        }
        this._value = _value;
    }

    public ProtocolVersion(ProtocolVersion source) {
        this._value = source._value;
    }

    public static ProtocolVersion getDefaultInstance(String defaultValue) {
        return new ProtocolVersion(new Short(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProtocolVersion [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

