/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import java.util.Arrays;
import java.util.Objects;
import javax.servlet.Filter;
import org.opendaylight.aaa.shiro.filters.AAAShiroFilter;
import org.opendaylight.aaa.shiro.web.env.AAAShiroWebEnvironment;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextSecurer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ShiroWebContextSecurer
implements WebContextSecurer {
    private final AAAShiroWebEnvironment webEnvironment;

    @Activate
    public ShiroWebContextSecurer(@Reference AAAShiroWebEnvironment webEnvironment) {
        this.webEnvironment = Objects.requireNonNull(webEnvironment);
    }

    public void requireAuthentication(WebContext.Builder webContextBuilder, boolean asyncSupported, String ... urlPatterns) {
        FilterDetails.Builder filterBuilder = FilterDetails.builder().filter((Filter)new AAAShiroFilter(this.webEnvironment)).asyncSupported(asyncSupported);
        Arrays.stream(urlPatterns).forEach(arg_0 -> ((FilterDetails.Builder)filterBuilder).addUrlPattern(arg_0));
        webContextBuilder.addFilter(filterBuilder.build());
    }
}

