/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.util.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UntrustedSSL {
    private UntrustedSSL() {
    }

    public static HostnameVerifier getHostnameVerifier() {
        return InsecureHostnameVerifier.INSTANCE;
    }

    public static SSLContext getSSLContext() {
        return InsecureSSLContext.INSTANCE;
    }

    private static final class InsecureHostnameVerifier {
        private static final HostnameVerifier INSTANCE = (hostname, session) -> true;

        private InsecureHostnameVerifier() {
        }
    }

    private static final class InsecureSSLContext {
        private static final Logger LOG = LoggerFactory.getLogger(InsecureSSLContext.class);
        private static final SSLContext INSTANCE = InsecureSSLContext.buildSSLContext();

        private InsecureSSLContext() {
        }

        private static SSLContext buildSSLContext() {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, InsecureTrustManager.INSTANCE, null);
                return sslContext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LOG.error("Error initializing SSLContext", (Throwable)e);
                return null;
            }
        }
    }

    private static final class InsecureTrustManager {
        private static final TrustManager[] INSTANCE = new TrustManager[]{new X509TrustManager(){
            private final X509Certificate[] empty = new X509Certificate[0];

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.empty;
            }
        }};

        private InsecureTrustManager() {
        }
    }
}

