/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.util.http;

import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.opendaylight.aaa.shiro.realm.util.http.SimpleHttpRequest;

public class SimpleHttpClient {
    private final Client client;

    SimpleHttpClient(Client client) {
        this.client = client;
    }

    public static Builder clientBuilder() {
        return SimpleHttpClient.clientBuilder(ClientBuilder.newBuilder());
    }

    public static Builder clientBuilder(ClientBuilder clientBuilder) {
        return new Builder(clientBuilder);
    }

    public <T> SimpleHttpRequest.Builder<T> requestBuilder(Class<T> outputType) {
        return new SimpleHttpRequest.Builder<T>(this.client, outputType);
    }

    public static class Builder {
        private final ClientBuilder clientBuilder;

        Builder(ClientBuilder clientBuilder) {
            this.clientBuilder = Objects.requireNonNull(clientBuilder);
        }

        public Builder sslContext(SSLContext context) {
            this.clientBuilder.sslContext(context);
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier verifier) {
            this.clientBuilder.hostnameVerifier(verifier);
            return this;
        }

        public Builder provider(Class<?> provider) {
            this.clientBuilder.register(provider);
            return this;
        }

        public SimpleHttpClient build() {
            return new SimpleHttpClient(this.clientBuilder.build());
        }
    }
}

