/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;
import org.opendaylight.aaa.shiro.principal.ODLPrincipalImpl;
import org.opendaylight.aaa.shiro.realm.util.TokenUtils;
import org.opendaylight.aaa.shiro.realm.util.http.header.HeaderUtils;
import org.opendaylight.aaa.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthRealm.class);
    private static final ThreadLocal<TokenAuthenticators> AUTHENICATORS_TL = new ThreadLocal();
    private static final ThreadLocal<AuthenticationService> AUTH_SERVICE_TL = new ThreadLocal();
    private static final ThreadLocal<TokenStore> TOKEN_STORE_TL = new ThreadLocal();
    private final TokenAuthenticators authenticators;
    private final AuthenticationService authService;
    private final TokenStore tokenStore;

    public TokenAuthRealm() {
        this(TokenAuthRealm.verifyLoad(AUTH_SERVICE_TL), TokenAuthRealm.verifyLoad(AUTHENICATORS_TL), TOKEN_STORE_TL.get());
    }

    public TokenAuthRealm(AuthenticationService authService, TokenAuthenticators authenticators) {
        this(authService, authenticators, null);
    }

    public TokenAuthRealm(AuthenticationService authService, TokenAuthenticators authenticators, @Nullable TokenStore tokenStore) {
        this.authService = Objects.requireNonNull(authService);
        this.authenticators = Objects.requireNonNull(authenticators);
        this.tokenStore = tokenStore;
        super.setName("TokenAuthRealm");
    }

    public static Registration prepareForLoad(AuthenticationService authService, TokenAuthenticators authenticators, @Nullable TokenStore tokenStore) {
        AUTH_SERVICE_TL.set(Objects.requireNonNull(authService));
        AUTHENICATORS_TL.set(Objects.requireNonNull(authenticators));
        TOKEN_STORE_TL.set(tokenStore);
        return () -> {
            AUTH_SERVICE_TL.remove();
            AUTHENICATORS_TL.remove();
            TOKEN_STORE_TL.remove();
        };
    }

    private static <T> T verifyLoad(ThreadLocal<T> threadLocal) {
        return (T)Verify.verifyNotNull(threadLocal.get(), (String)"TokenAuthRealm loading not prepared", (Object[])new Object[0]);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Object primaryPrincipal = principalCollection.getPrimaryPrincipal();
        if (primaryPrincipal instanceof ODLPrincipal) {
            ODLPrincipal odlPrincipal = (ODLPrincipal)primaryPrincipal;
            return new SimpleAuthorizationInfo(odlPrincipal.getRoles());
        }
        LOG.error("Could not decode authorization request: {} is not a known principal type", primaryPrincipal);
        return new SimpleAuthorizationInfo();
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String password;
        String domain;
        String username;
        if (authenticationToken == null) {
            throw new AuthenticationException("{\"error\":\"Unable to decode credentials\"}");
        }
        try {
            String possiblyQualifiedUser = TokenUtils.extractUsername(authenticationToken);
            username = HeaderUtils.extractUsername(possiblyQualifiedUser);
            domain = HeaderUtils.extractDomain(possiblyQualifiedUser);
            password = TokenUtils.extractPassword(authenticationToken);
        }
        catch (ClassCastException e) {
            throw new AuthenticationException("{\"error\":\"Only basic authentication is supported by TokenAuthRealm\"}", (Throwable)e);
        }
        if (!Strings.isNullOrEmpty((String)password)) {
            Map<String, List<String>> headers = HeaderUtils.formHeaders(username, password, domain);
            for (TokenAuth ta : this.authenticators.getTokenAuthCollection()) {
                try {
                    LOG.debug("Authentication attempt using {}", (Object)ta.getClass().getName());
                    Authentication auth = ta.validate(headers);
                    if (auth == null) continue;
                    LOG.debug("Authentication attempt successful");
                    this.authService.set(auth);
                    ODLPrincipal odlPrincipal = ODLPrincipalImpl.createODLPrincipal(auth);
                    return new SimpleAuthenticationInfo((Object)odlPrincipal, (Object)password.toCharArray(), this.getName());
                }
                catch (AuthenticationException ae) {
                    LOG.debug("Authentication attempt unsuccessful", (Throwable)ae);
                    throw new AuthenticationException("{\"error\":\"Could not authenticate\"}", (Throwable)ae);
                }
            }
        }
        LOG.debug("Authentication failed: exhausted TokenAuth resources");
        return null;
    }
}

