/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Destroyable;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.api.shiro.principal.ODLPrincipal;
import org.opendaylight.aaa.shiro.principal.ODLPrincipalImpl;
import org.opendaylight.aaa.shiro.realm.util.TokenUtils;
import org.opendaylight.aaa.shiro.realm.util.http.header.HeaderUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Authentication;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Grants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Roles;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users.Users;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalRealm
extends AuthorizingRealm
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalRealm.class);
    private static final DataTreeIdentifier<Authentication> AUTH_TREE_ID = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(Authentication.class));
    private static final ThreadLocal<PasswordHashService> PASSWORD_HASH_SERVICE_TL = new ThreadLocal();
    private static final ThreadLocal<DataBroker> DATABROKER_TL = new ThreadLocal();
    private final PasswordHashService passwordHashService;
    private final Registration reg;
    private volatile ListenableFuture<Optional<Authentication>> authentication;

    public MdsalRealm() {
        this(MdsalRealm.verifyLoad(PASSWORD_HASH_SERVICE_TL), MdsalRealm.verifyLoad(DATABROKER_TL));
    }

    private static <T> T verifyLoad(ThreadLocal<T> threadLocal) {
        return (T)Verify.verifyNotNull(threadLocal.get(), (String)"MdsalRealm not prepared for loading", (Object[])new Object[0]);
    }

    public MdsalRealm(PasswordHashService passwordHashService, DataBroker dataBroker) {
        this.passwordHashService = Objects.requireNonNull(passwordHashService);
        try (ReadTransaction tx = dataBroker.newReadOnlyTransaction();){
            this.authentication = tx.read(AUTH_TREE_ID.datastore(), AUTH_TREE_ID.path());
        }
        this.reg = dataBroker.registerDataListener(AUTH_TREE_ID, this::onAuthenticationChanged);
        LOG.info("MdsalRealm created");
    }

    public static Registration prepareForLoad(PasswordHashService passwordHashService, DataBroker dataBroker) {
        PASSWORD_HASH_SERVICE_TL.set(Objects.requireNonNull(passwordHashService));
        DATABROKER_TL.set(Objects.requireNonNull(dataBroker));
        return () -> {
            PASSWORD_HASH_SERVICE_TL.remove();
            DATABROKER_TL.remove();
        };
    }

    private void onAuthenticationChanged(Authentication data) {
        LOG.debug("Updating authentication information to {}", (Object)data);
        this.authentication = Futures.immediateFuture(Optional.ofNullable(data));
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        HashSet authRoles = new HashSet();
        ODLPrincipal odlPrincipal = (ODLPrincipal)principalCollection.getPrimaryPrincipal();
        this.getAuthenticationContainer().ifPresent(auth -> {
            Grants grants = auth.getGrants();
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants.Grants grant : grants.nonnullGrants().values()) {
                Roles roles;
                if (!grant.getUserid().equals(odlPrincipal.getUserId()) || (roles = auth.getRoles()) == null) continue;
                for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles.Roles role : roles.nonnullRoles().values()) {
                    if (!role.getRoleid().equals(grant.getRoleid())) continue;
                    authRoles.add(role.getRoleid());
                }
            }
        });
        return new SimpleAuthorizationInfo(authRoles);
    }

    private Optional<Authentication> getAuthenticationContainer() {
        try {
            return (Optional)this.authentication.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Couldn't access authentication container", (Throwable)e);
            return Optional.empty();
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String username = TokenUtils.extractUsername(authenticationToken);
        Optional<Authentication> opt = this.getAuthenticationContainer();
        if (opt.isPresent()) {
            Authentication auth = opt.orElseThrow();
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Users users = auth.getUsers();
            for (Users u : users.nonnullUsers().values()) {
                String inputPassword;
                String inputUsername = HeaderUtils.extractUsername(username);
                String domainId = HeaderUtils.extractDomain(username);
                String inputUserId = String.format("%s@%s", inputUsername, domainId);
                boolean userEnabled = u.getEnabled();
                if (!userEnabled) {
                    LOG.trace("userId={} is skipped because it is disabled", (Object)u.getUserid());
                }
                if (!userEnabled || !u.getUserid().equals(inputUserId) || !this.passwordHashService.passwordsMatch(inputPassword = TokenUtils.extractPassword(authenticationToken), u.getPassword(), u.getSalt())) continue;
                return new SimpleAuthenticationInfo((Object)ODLPrincipalImpl.createODLPrincipal(inputUsername, domainId, inputUserId), (Object)inputPassword, this.getName());
            }
        }
        LOG.debug("Couldn't access the authentication container");
        throw new AuthenticationException(String.format("Couldn't authenticate %s", username));
    }

    public void destroy() {
        this.reg.close();
    }
}

