/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/users")
public class UserHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UserHandler.class);
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public UserHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = iidMStore;
        this.claimCache = claimCache;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getUsers() {
        Users users;
        LOG.info("GET /auth/v1/users  (extracts all users)");
        try {
            users = this.iidMStore.getUsers();
        }
        catch (IDMStoreException se) {
            return UserHandler.internalError("getting", (Exception)((Object)se));
        }
        users.getUsers().forEach(UserHandler::redactUserPasswordInfo);
        return Response.ok((Object)users).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="id") String id) {
        User user;
        LOG.info("GET auth/v1/users/ {}  (extract user with specified id)", (Object)id);
        try {
            user = this.iidMStore.readUser(id);
        }
        catch (IDMStoreException se) {
            return UserHandler.internalError("getting", (Exception)((Object)se));
        }
        if (user == null) {
            return new IDMError(404, "user not found! id: " + id, "").response();
        }
        UserHandler.redactUserPasswordInfo(user);
        return Response.ok((Object)user).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUser(@Context UriInfo info, User user) {
        User createdUser;
        String userName;
        LOG.info("POST /auth/v1/users  (create a user with the specified payload");
        if (user.getUserid() != null) {
            String errorMessage = "do not specify userId, it will be assigned automatically for you";
            LOG.debug("do not specify userId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify userId, it will be assigned automatically for you");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)idmError).build();
        }
        if (user.isEnabled() == null) {
            user.setEnabled(true);
        }
        if ((userName = user.getName()) == null) {
            return UserHandler.missingRequiredField("name");
        }
        if (userName.length() > 256) {
            return UserHandler.providedFieldTooLong("name", 256);
        }
        String domainId = user.getDomainid();
        if (domainId == null) {
            return UserHandler.missingRequiredField("domain");
        }
        if (domainId.length() > 256) {
            return UserHandler.providedFieldTooLong("domain", 256);
        }
        String userDescription = user.getDescription();
        if (userDescription == null) {
            user.setDescription("");
        } else if (userDescription.length() > 256) {
            return UserHandler.providedFieldTooLong("description", 256);
        }
        String userEmail = user.getEmail();
        if (userEmail == null) {
            user.setEmail("");
        } else if (userEmail.length() > 256) {
            return UserHandler.providedFieldTooLong("email", 256);
        }
        String userPassword = user.getPassword();
        if (userPassword == null) {
            user.setPassword("changeme");
        } else if (userPassword.length() > 256) {
            return UserHandler.providedFieldTooLong("password", 256);
        }
        try {
            createdUser = this.iidMStore.writeUser(user);
        }
        catch (IDMStoreException se) {
            return UserHandler.internalError("creating", (Exception)((Object)se));
        }
        user.setUserid(createdUser.getUserid());
        UserHandler.redactUserPasswordInfo(user);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)user).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putUser(@Context UriInfo info, User user, @PathParam(value="id") String id) {
        User newUser;
        LOG.info("PUT /auth/v1/users/{}  (Updates a user account)", (Object)id);
        user.setUserid(id);
        if (UserHandler.checkInputFieldLength(user.getPassword())) {
            return UserHandler.providedFieldTooLong("password", 256);
        }
        if (UserHandler.checkInputFieldLength(user.getName())) {
            return UserHandler.providedFieldTooLong("name", 256);
        }
        if (UserHandler.checkInputFieldLength(user.getDescription())) {
            return UserHandler.providedFieldTooLong("description", 256);
        }
        if (UserHandler.checkInputFieldLength(user.getEmail())) {
            return UserHandler.providedFieldTooLong("email", 256);
        }
        if (UserHandler.checkInputFieldLength(user.getDomainid())) {
            return UserHandler.providedFieldTooLong("domain", 256);
        }
        try {
            newUser = this.iidMStore.updateUser(user);
        }
        catch (IDMStoreException se) {
            return UserHandler.internalError("updating", (Exception)((Object)se));
        }
        if (newUser == null) {
            return new IDMError(404, String.format("User not found for id %s", id), "").response();
        }
        this.claimCache.clear();
        UserHandler.redactUserPasswordInfo(newUser);
        return Response.ok((Object)newUser).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteUser(@Context UriInfo info, @PathParam(value="id") String id) {
        User user;
        LOG.info("DELETE /auth/v1/users/{}  (Delete a user account)", (Object)id);
        try {
            user = this.iidMStore.deleteUser(id);
        }
        catch (IDMStoreException se) {
            return UserHandler.internalError("deleting", (Exception)((Object)se));
        }
        if (user == null) {
            return new IDMError(404, "Error deleting user.  Couldn't find user with id " + id, "").response();
        }
        this.claimCache.clear();
        return Response.noContent().build();
    }

    private static Response internalError(String verbal, Exception ex) {
        LOG.error("There was an internal error {} the user", (Object)verbal, (Object)ex);
        return new IDMError(500, String.format("There was an internal error %s the user", verbal)).response();
    }

    private static Response missingRequiredField(String fieldName) {
        return new IDMError(400, String.format("%s is required to create the user account.  Please provide a %s in your payload.", fieldName, fieldName), "").response();
    }

    private static Response providedFieldTooLong(String fieldName, int maxFieldLength) {
        return new IDMError(400, UserHandler.getProvidedFieldTooLongMessage(fieldName, maxFieldLength), "").response();
    }

    private static String getProvidedFieldTooLongMessage(String fieldName, int maxFieldLength) {
        return String.format("The provided %s field is too long.  The max length is %s.", fieldName, maxFieldLength);
    }

    private static void redactUserPasswordInfo(User user) {
        user.setPassword("**********");
        user.setSalt("**********");
    }

    private static boolean checkInputFieldLength(String inputField) {
        return inputField != null && inputField.length() > 256;
    }
}

