/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.Roles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/roles")
public class RoleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoleHandler.class);
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public RoleHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = iidMStore;
        this.claimCache = claimCache;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRoles() {
        Roles roles;
        LOG.info("get /roles");
        try {
            roles = this.iidMStore.getRoles();
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error getting the roles", (Throwable)e);
            return new IDMError(500, "internal error getting roles", e.getMessage()).response();
        }
        return Response.ok((Object)roles).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getRole(@PathParam(value="id") String id) {
        Role role;
        LOG.info("get /roles/{}", (Object)id);
        try {
            role = this.iidMStore.readRole(id);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error getting the role", (Throwable)e);
            return new IDMError(500, "internal error getting roles", e.getMessage()).response();
        }
        if (role == null) {
            return new IDMError(404, "role not found id:" + id, "").response();
        }
        return Response.ok((Object)role).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRole(@Context UriInfo info, Role role) {
        Role newRole;
        LOG.info("Post /roles");
        if (role.getRoleid() != null) {
            String errorMessage = "do not specify roleId, it will be assigned automatically for you";
            LOG.debug("do not specify roleId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify roleId, it will be assigned automatically for you");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)idmError).build();
        }
        if (role.getName() == null) {
            return new IDMError(404, "name must be defined on role create", "").response();
        }
        if (role.getName().length() > 256) {
            return new IDMError(400, "role name max length is :256", "").response();
        }
        if (role.getDomainid() == null) {
            return new IDMError(404, "The role's domain must be defined on role when creating a role.", "").response();
        }
        if (role.getDomainid().length() > 256) {
            return new IDMError(400, "role domain max length is :256", "").response();
        }
        if (role.getDescription() == null) {
            role.setDescription("");
        } else if (role.getDescription().length() > 256) {
            return new IDMError(400, "role description max length is :256", "").response();
        }
        try {
            newRole = this.iidMStore.writeRole(role);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error creating role", (Throwable)e);
            return new IDMError(500, "internal error creating role", e.getMessage()).response();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newRole).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putRole(@Context UriInfo info, Role role, @PathParam(value="id") String id) {
        Role newRole;
        LOG.info("put /roles/{}", (Object)id);
        role.setRoleid(id);
        if (role.getName() != null && role.getName().length() > 256) {
            return new IDMError(400, "role name max length is :256", "").response();
        }
        if (role.getDescription() != null && role.getDescription().length() > 256) {
            return new IDMError(400, "role description max length is :256", "").response();
        }
        try {
            newRole = this.iidMStore.updateRole(role);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error putting role", (Throwable)e);
            return new IDMError(500, "internal error putting role", e.getMessage()).response();
        }
        if (newRole == null) {
            return new IDMError(404, "role id not found :" + id, "").response();
        }
        this.claimCache.clear();
        return Response.ok((Object)newRole).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteRole(@Context UriInfo info, @PathParam(value="id") String id) {
        Role role;
        LOG.info("Delete /roles/{}", (Object)id);
        try {
            role = this.iidMStore.deleteRole(id);
        }
        catch (IDMStoreException e) {
            LOG.error("Internal error deleting role", (Throwable)e);
            return new IDMError(500, "internal error deleting role", e.getMessage()).response();
        }
        if (role == null) {
            return new IDMError(404, "role id not found :" + id, "").response();
        }
        this.claimCache.clear();
        return Response.noContent().build();
    }
}

