/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.provider.GsonProvider;
import org.opendaylight.aaa.shiro.idm.DomainHandler;
import org.opendaylight.aaa.shiro.idm.RoleHandler;
import org.opendaylight.aaa.shiro.idm.UserHandler;

public class IdmLightApplication
extends Application {
    public static final int MAX_FIELD_LEN = 256;
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public IdmLightApplication(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = Objects.requireNonNull(iidMStore);
        this.claimCache = Objects.requireNonNull(claimCache);
    }

    public Set<Object> getSingletons() {
        return ImmutableSet.of(new GsonProvider(), (Object)new DomainHandler(this.iidMStore, this.claimCache), (Object)new RoleHandler(this.iidMStore, this.claimCache), (Object)new UserHandler(this.iidMStore, this.claimCache));
    }
}

