/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import java.util.ArrayList;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Domains;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.Roles;
import org.opendaylight.aaa.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/domains")
public class DomainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DomainHandler.class);
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public DomainHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = Objects.requireNonNull(iidMStore);
        this.claimCache = Objects.requireNonNull(claimCache);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomains() {
        Domains domains;
        LOG.info("Get /domains");
        try {
            domains = this.iidMStore.getDomains();
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domains");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        return Response.ok((Object)domains).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getDomain(@PathParam(value="id") String domainId) {
        Domain domain;
        LOG.info("Get /domains/{}", (Object)domainId);
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! domain id :" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        return Response.ok((Object)domain).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDomain(@Context UriInfo info, Domain domain) {
        Domain newDomain;
        LOG.info("Post /domains");
        if (domain.getDomainid() != null) {
            String errorMessage = "do not specify domainId, it will be assigned automatically for you";
            LOG.debug("do not specify domainId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify domainId, it will be assigned automatically for you");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)idmError).build();
        }
        if (domain.isEnabled() == null) {
            domain.setEnabled(Boolean.valueOf(false));
        }
        if (domain.getName() == null) {
            domain.setName("");
        }
        if (domain.getDescription() == null) {
            domain.setDescription("");
        }
        try {
            newDomain = this.iidMStore.writeDomain(domain);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newDomain).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putDomain(@Context UriInfo info, Domain domain, @PathParam(value="id") String domainId) {
        Domain newDomain;
        LOG.info("Put /domains/{}", (Object)domainId);
        domain.setDomainid(domainId);
        try {
            newDomain = this.iidMStore.updateDomain(domain);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error putting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (newDomain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.ok((Object)newDomain).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteDomain(@Context UriInfo info, @PathParam(value="id") String domainId) {
        Domain domain;
        LOG.info("Delete /domains/{}", (Object)domainId);
        try {
            domain = this.iidMStore.deleteDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error deleting Domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{did}/users/{uid}/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createGrant(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId, Grant grant) {
        Grant newGrant;
        Grant existingGrant;
        Role role;
        String roleId;
        User user;
        Domain domain;
        LOG.info("Post /domains/{}/users/{}/roles", (Object)domainId, (Object)userId);
        if (grant.getGrantid() != null) {
            String errorMessage = "do not specify grantId, it will be assigned automatically for you";
            LOG.debug("do not specify grantId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify grantId, it will be assigned automatically for you");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)idmError).build();
        }
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! domain id :" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        grant.setDomainid(domainId);
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        grant.setUserid(userId);
        try {
            roleId = grant.getRoleid();
        }
        catch (NumberFormatException nfe) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Invalid Role id:" + grant.getRoleid());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        LOG.info("roleid = {}", (Object)roleId);
        try {
            role = this.iidMStore.readRole(roleId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting role");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (role == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! role:" + grant.getRoleid());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        try {
            existingGrant = this.iidMStore.readGrant(domainId, userId, roleId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (existingGrant != null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Grant already exists for did:" + domainId + " uid:" + userId + " rid:" + roleId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)idmerror).build();
        }
        try {
            newGrant = this.iidMStore.writeGrant(grant);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException: ", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newGrant).build();
    }

    @GET
    @Path(value="/{did}/users/{uid}/roles")
    @Produces(value={"application/json"})
    public Response getRoles(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId) {
        User user;
        Domain domain;
        LOG.info("GET /domains/{}/users/{}/roles", (Object)domainId, (Object)userId);
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        try {
            for (Grant grant : this.iidMStore.getGrants(domainId, userId).getGrants()) {
                roleList.add(this.iidMStore.readRole(grant.getRoleid()));
            }
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting Roles");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        Roles roles = new Roles();
        roles.setRoles(roleList);
        return Response.ok((Object)roles).build();
    }

    @DELETE
    @Path(value="/{did}/users/{uid}/roles/{rid}")
    public Response deleteGrant(@Context UriInfo info, @PathParam(value="did") String domainId, @PathParam(value="uid") String userId, @PathParam(value="rid") String roleId) {
        Role role;
        User user;
        Domain domain;
        try {
            domain = this.iidMStore.readDomain(domainId);
        }
        catch (IDMStoreException e) {
            LOG.error("Error deleting Grant", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting domain");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (domain == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Domain id:" + domainId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        try {
            user = this.iidMStore.readUser(userId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting user");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (user == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! User id:" + userId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        try {
            role = this.iidMStore.readRole(roleId);
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error getting Role");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        if (role == null) {
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Not found! Role id:" + roleId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
        }
        try {
            Grant existingGrant = this.iidMStore.readGrant(domainId, userId, roleId);
            if (existingGrant == null) {
                IDMError idmerror = new IDMError();
                idmerror.setMessage("Grant does not exist for did:" + domainId + " uid:" + userId + " rid:" + roleId);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)idmerror).build();
            }
            this.iidMStore.deleteGrant(existingGrant.getGrantid());
        }
        catch (IDMStoreException e) {
            LOG.error("StoreException", (Throwable)e);
            IDMError idmerror = new IDMError();
            idmerror.setMessage("Internal error creating grant");
            idmerror.setDetails(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)idmerror).build();
        }
        this.claimCache.clear();
        return Response.noContent().build();
    }
}

