/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GsonProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static final String PRETTY_PRINT = "pretty-print";
    private final Gson gson;
    private final Gson prettyGson;
    @Context
    private UriInfo ui;

    public GsonProvider() {
        GsonBuilder builder = new GsonBuilder().serializeNulls().enableComplexMapKeySerialization();
        this.gson = builder.create();
        this.prettyGson = builder.setPrettyPrinting().create();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try (InputStreamReader reader = new InputStreamReader(entityStream, StandardCharsets.UTF_8);){
            Object object = this.gson.fromJson((Reader)reader, type);
            return (T)object;
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(T type, Class<?> theClass, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void writeTo(T type, Class<?> theClass, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        try (PrintWriter printWriter = new PrintWriter(entityStream);){
            MultivaluedMap queryParameters = this.ui != null ? this.ui.getQueryParameters() : null;
            String json = queryParameters != null && queryParameters.containsKey((Object)PRETTY_PRINT) ? this.prettyGson.toJson(type) : this.gson.toJson(type);
            printWriter.write(json);
            printWriter.flush();
        }
    }
}

