/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.authenticator;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.jolokia.osgi.security.Authenticator;
import org.opendaylight.aaa.shiro.web.env.AAAShiroWebEnvironment;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class ODLAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ODLAuthenticator.class);
    private final AAAShiroWebEnvironment env;

    @Activate
    public ODLAuthenticator(@Reference AAAShiroWebEnvironment env) {
        this.env = Objects.requireNonNull(env);
    }

    public boolean authenticate(HttpServletRequest httpServletRequest) {
        String authorization = httpServletRequest.getHeader("Authorization");
        LOG.trace("Incoming Jolokia authentication attempt: {}", (Object)authorization);
        if (authorization == null || !authorization.startsWith("Basic")) {
            return false;
        }
        try {
            String base64Creds = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Creds), StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            UsernamePasswordToken upt = new UsernamePasswordToken();
            upt.setUsername(values[0]);
            upt.setPassword(values[1].toCharArray());
            Subject subject = new Subject.Builder(this.env.getSecurityManager()).buildSubject();
            try {
                return ODLAuthenticator.login(subject, upt);
            }
            catch (UnknownSessionException e) {
                LOG.debug("Couldn't log in {} - logging out and retrying...", (Object)upt, (Object)e);
                ODLAuthenticator.logout(subject);
                return ODLAuthenticator.login(subject, upt);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.trace("Formatting issue with basic auth credentials: {}", (Object)authorization, (Object)e);
            return false;
        }
    }

    private static void logout(Subject subject) {
        try {
            subject.logout();
            Session session = subject.getSession(false);
            if (session != null) {
                session.stop();
            }
        }
        catch (ShiroException e) {
            LOG.debug("Couldn't log out {}", (Object)subject, (Object)e);
        }
    }

    private static boolean login(Subject subject, UsernamePasswordToken upt) {
        try {
            subject.login((AuthenticationToken)upt);
        }
        catch (AuthenticationException e) {
            LOG.trace("Couldn't authenticate the subject: {}", (Object)subject, (Object)e);
            return false;
        }
        return true;
    }
}

