/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa;

import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.PasswordCredentialAuth;
import org.opendaylight.aaa.api.StoreBuilder;
import org.opendaylight.aaa.api.TokenAuth;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.datastore.h2.H2TokenStore;
import org.opendaylight.aaa.tokenauthrealm.auth.HttpBasicAuth;
import org.opendaylight.aaa.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAAShiroProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AAAShiroProvider.class);
    private final TokenStore tokenStore;
    private final TokenAuthenticators tokenAuthenticators;

    public AAAShiroProvider(PasswordCredentialAuth credentialAuth, DatastoreConfig datastoreConfig, IIDMStore iidmStore) {
        if (datastoreConfig != null && datastoreConfig.getStore() == DatastoreConfig.Store.H2DataStore) {
            this.tokenStore = new H2TokenStore(datastoreConfig.getTimeToLive().longValue(), datastoreConfig.getTimeToWait().longValue());
            AAAShiroProvider.initializeIIDMStore(iidmStore);
            this.tokenAuthenticators = new TokenAuthenticators(new TokenAuth[]{new HttpBasicAuth((CredentialAuth)credentialAuth)});
            LOG.info("AAAShiroProvider Session Initiated");
        } else {
            this.tokenStore = null;
            this.tokenAuthenticators = new TokenAuthenticators(new TokenAuth[0]);
            LOG.info("AAA Datastore has not been initialized");
        }
    }

    @Override
    public void close() {
        LOG.info("AAAShiroProvider Closed");
    }

    private static void initializeIIDMStore(IIDMStore iidmStore) {
        try {
            new StoreBuilder(iidmStore).initWithDefaultUsers("sdn");
        }
        catch (IDMStoreException e) {
            LOG.error("Failed to initialize data in store", (Throwable)e);
        }
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public TokenAuthenticators getTokenAuthenticators() {
        return this.tokenAuthenticators;
    }
}

