/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workspace.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.ObjectInstance;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.opencastproject.assetmanager.util.AssetPathUtils;
import org.opencastproject.assetmanager.util.DistributionPathUtils;
import org.opencastproject.cleanup.RecursiveDirectoryCleaner;
import org.opencastproject.mediapackage.identifier.Id;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.TrustedHttpClientException;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.HttpUtil;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.PathSupport;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.Arrays;
import org.opencastproject.util.data.Effect;
import org.opencastproject.util.data.Either;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Prelude;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.util.jmx.JmxUtil;
import org.opencastproject.workingfilerepository.api.PathMappable;
import org.opencastproject.workingfilerepository.api.WorkingFileRepository;
import org.opencastproject.workspace.api.Workspace;
import org.opencastproject.workspace.impl.WorkspaceCleaner;
import org.opencastproject.workspace.impl.jmx.WorkspaceBean;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workspace"}, immediate=true, service={Workspace.class})
public final class WorkspaceImpl
implements Workspace {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceImpl.class);
    public static final String WORKSPACE_DIR_KEY = "org.opencastproject.workspace.rootdir";
    public static final String STORAGE_DIR_KEY = "org.opencastproject.storage.dir";
    public static final String WORKSPACE_CLEANUP_PERIOD_KEY = "org.opencastproject.workspace.cleanup.period";
    public static final String WORKSPACE_CLEANUP_MAX_AGE_KEY = "org.opencastproject.workspace.cleanup.max.age";
    private static final String JMX_WORKSPACE_TYPE = "Workspace";
    private static final String UNKNOWN_FILENAME = "unknown";
    private WorkspaceBean workspaceBean = new WorkspaceBean(this);
    private ObjectInstance registeredMXBean;
    private final Object lock = new Object();
    private String wsRoot = null;
    private boolean linkingEnabled = false;
    private TrustedHttpClient trustedHttpClient;
    private SecurityService securityService = null;
    private WorkingFileRepository wfr = null;
    private PathMappable pathMappable = null;
    private CopyOnWriteArraySet<String> staticCollections = new CopyOnWriteArraySet();
    private boolean waitForResourceFlag = false;
    private List<String> assetManagerPaths = null;
    private String downloadUrl = null;
    private String downloadPath = null;
    private WorkspaceCleaner workspaceCleaner = null;
    private static final long TIMEOUT = 120000L;
    private static final long INTERVAL = 1000L;

    public WorkspaceImpl() {
    }

    public WorkspaceImpl(String rootDirectory, boolean waitForResource) {
        this.wsRoot = rootDirectory;
        this.waitForResourceFlag = waitForResource;
    }

    private boolean ensureContextProp(ComponentContext cc, String prop) {
        return cc != null && cc.getBundleContext().getProperty(prop) != null;
    }

    @Activate
    public void activate(ComponentContext cc) {
        File f;
        if (this.wsRoot == null) {
            if (this.ensureContextProp(cc, WORKSPACE_DIR_KEY)) {
                this.wsRoot = cc.getBundleContext().getProperty(WORKSPACE_DIR_KEY);
                logger.info("CONFIG org.opencastproject.workspace.rootdir: " + this.wsRoot);
            } else if (this.ensureContextProp(cc, STORAGE_DIR_KEY)) {
                this.wsRoot = PathSupport.concat((String)cc.getBundleContext().getProperty(STORAGE_DIR_KEY), (String)"workspace");
                logger.warn("CONFIG org.opencastproject.workspace.rootdir is missing: falling back to " + this.wsRoot);
            } else {
                throw new IllegalStateException("Configuration 'org.opencastproject.workspace.rootdir' is missing");
            }
        }
        if (!(f = new File(this.wsRoot)).exists()) {
            try {
                FileUtils.forceMkdir((File)f);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create workspace directory.", e);
            }
        }
        if (this.pathMappable != null) {
            File targetFile;
            String wfrRoot = this.pathMappable.getPathPrefix();
            File srcFile = new File(wfrRoot, ".linktest");
            try {
                FileUtils.touch((File)srcFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("The working file repository seems read-only", e);
            }
            try {
                targetFile = File.createTempFile(".linktest.", ".tmp", new File(this.wsRoot));
                targetFile.delete();
            }
            catch (IOException e) {
                throw new IllegalStateException("The workspace seems read-only", e);
            }
            this.linkingEnabled = FileSupport.supportsLinking((File)srcFile, (File)targetFile);
            FileUtils.deleteQuietly((File)targetFile);
            if (this.linkingEnabled) {
                logger.info("Hard links between the working file repository and the workspace enabled");
            } else {
                logger.warn("Hard links between the working file repository and the workspace are not possible");
                logger.warn("This will increase the overall amount of disk space used");
            }
        }
        int garbageCollectionPeriodInSeconds = -1;
        if (this.ensureContextProp(cc, WORKSPACE_CLEANUP_PERIOD_KEY)) {
            String period = cc.getBundleContext().getProperty(WORKSPACE_CLEANUP_PERIOD_KEY);
            try {
                garbageCollectionPeriodInSeconds = Integer.parseInt(period);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for workspace garbage collection period ({}={})", (Object)WORKSPACE_CLEANUP_PERIOD_KEY, (Object)period);
                garbageCollectionPeriodInSeconds = -1;
            }
        }
        int maxAgeInSeconds = -1;
        if (this.ensureContextProp(cc, WORKSPACE_CLEANUP_MAX_AGE_KEY)) {
            String age = cc.getBundleContext().getProperty(WORKSPACE_CLEANUP_MAX_AGE_KEY);
            try {
                maxAgeInSeconds = Integer.parseInt(age);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for workspace garbage collection max age ({}={})", (Object)WORKSPACE_CLEANUP_MAX_AGE_KEY, (Object)age);
                maxAgeInSeconds = -1;
            }
        }
        this.registeredMXBean = JmxUtil.registerMXBean((Object)this.workspaceBean, (String)JMX_WORKSPACE_TYPE);
        if (garbageCollectionPeriodInSeconds > 0) {
            this.workspaceCleaner = new WorkspaceCleaner(this, garbageCollectionPeriodInSeconds, maxAgeInSeconds);
            this.workspaceCleaner.schedule();
        }
        this.staticCollections.add("archive");
        this.staticCollections.add("captions");
        this.staticCollections.add("composer");
        this.staticCollections.add("composite");
        this.staticCollections.add("coverimage");
        this.staticCollections.add("executor");
        this.staticCollections.add("inbox");
        this.staticCollections.add("ocrtext");
        this.staticCollections.add("subtitles");
        this.staticCollections.add("uploaded");
        this.staticCollections.add("videoeditor");
        this.staticCollections.add("videosegments");
        this.staticCollections.add("waveform");
        this.assetManagerPaths = AssetPathUtils.getAssetManagerPath((ComponentContext)cc);
        this.downloadUrl = DistributionPathUtils.getDownloadUrl((ComponentContext)cc);
        this.downloadPath = DistributionPathUtils.getDownloadPath((ComponentContext)cc);
    }

    @Deactivate
    public void deactivate() {
        JmxUtil.unregisterMXBean((ObjectInstance)this.registeredMXBean);
        if (this.workspaceCleaner != null) {
            this.workspaceCleaner.shutdown();
        }
    }

    public String toSafeName(String fileName) {
        return this.wfr.toSafeName(fileName);
    }

    public File get(URI uri) throws NotFoundException, IOException {
        return this.get(uri, false);
    }

    public File get(URI uri, boolean uniqueFilename) throws NotFoundException, IOException {
        File asset;
        File inWs = this.toWorkspaceFile(uri);
        if (uniqueFilename) {
            inWs = new File(FilenameUtils.removeExtension((String)inWs.getAbsolutePath()) + "-" + String.valueOf(UUID.randomUUID()) + "." + FilenameUtils.getExtension((String)inWs.getName()));
            logger.debug("Created unique filename: {}", (Object)inWs);
        }
        if (this.pathMappable != null && StringUtils.isNotBlank((CharSequence)this.pathMappable.getPathPrefix()) && StringUtils.isNotBlank((CharSequence)this.pathMappable.getUrlPrefix()) && uri.toString().startsWith(this.pathMappable.getUrlPrefix())) {
            String localPath = uri.toString().substring(this.pathMappable.getUrlPrefix().length());
            File wfrCopy = this.workingFileRepositoryFile(localPath);
            logger.trace("Looking up {} at {}", (Object)uri.toString(), (Object)wfrCopy.getAbsolutePath());
            if (wfrCopy.isFile()) {
                long workspaceFileLastModified;
                long l = workspaceFileLastModified = inWs.isFile() ? inWs.lastModified() : 0L;
                if (workspaceFileLastModified < wfrCopy.lastModified()) {
                    logger.debug("Replacing {} with an updated version from the file repository", (Object)inWs.getAbsolutePath());
                    IoSupport.locked((File)inWs, this.copyOrLink(wfrCopy));
                } else {
                    logger.debug("{} is up to date", (Object)inWs);
                }
                logger.debug("Getting {} directly from working file repository root at {}", (Object)uri, (Object)inWs);
                return new File(inWs.getAbsolutePath());
            }
            logger.warn("The working file repository and workspace paths don't match. Looking up {} at {} failed", (Object)uri.toString(), (Object)wfrCopy.getAbsolutePath());
        }
        if ((asset = AssetPathUtils.getLocalFile(this.assetManagerPaths, (String)this.securityService.getOrganization().getId(), (URI)uri)) != null) {
            logger.debug("Copy local file {} from asset manager to workspace", (Object)asset);
            Files.copy(asset.toPath(), inWs.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return new File(inWs.getAbsolutePath());
        }
        return (File)IoSupport.locked((File)inWs, this.downloadIfNecessary(uri));
    }

    public InputStream read(URI uri) throws NotFoundException, IOException {
        File asset;
        if (this.pathMappable != null && uri.toString().startsWith(this.pathMappable.getUrlPrefix())) {
            String localPath = uri.toString().substring(this.pathMappable.getUrlPrefix().length());
            File wfrCopy = this.workingFileRepositoryFile(localPath);
            logger.trace("Looking up {} at {} for read", (Object)uri, (Object)wfrCopy);
            if (wfrCopy.isFile()) {
                logger.debug("Getting {} directly from working file repository root at {} for read", (Object)uri, (Object)wfrCopy);
                return new FileInputStream(wfrCopy);
            }
            logger.warn("The working file repository URI and paths don't match. Looking up {} at {} failed", (Object)uri, (Object)wfrCopy);
        }
        if ((asset = AssetPathUtils.getLocalFile(this.assetManagerPaths, (String)this.securityService.getOrganization().getId(), (URI)uri)) != null) {
            return new FileInputStream(asset);
        }
        File publishedFile = DistributionPathUtils.getLocalFile((String)this.downloadPath, (String)this.downloadUrl, (String)this.securityService.getOrganization().getId(), (URI)uri);
        if (publishedFile != null) {
            return new FileInputStream(publishedFile);
        }
        return new DeleteOnCloseFileInputStream(this, this.get(uri, true));
    }

    private void copyOrLink(File src, File dst) throws IOException {
        if (this.linkingEnabled) {
            FileUtils.deleteQuietly((File)dst);
            FileSupport.link((File)src, (File)dst);
        } else {
            FileSupport.copy((File)src, (File)dst);
        }
    }

    private Effect<File> copyOrLink(final File src) {
        return new Effect.X<File>(){

            protected void xrun(File dst) throws IOException {
                WorkspaceImpl.this.copyOrLink(src, dst);
            }
        };
    }

    private Either<String, Option<File>> handleDownloadResponse(HttpResponse response, URI src, File dst) throws IOException {
        String url = src.toString();
        int status = response.getStatusLine().getStatusCode();
        switch (status) {
            case 404: {
                return Either.right((Object)Option.none(File.class));
            }
            case 304: {
                logger.debug("{} has not been modified.", (Object)url);
                return Either.right((Object)Option.some((Object)dst));
            }
            case 202: {
                logger.debug("{} is not ready, try again later.", (Object)url);
                return Either.left((Object)response.getHeaders("token")[0].getValue());
            }
            case 200: {
                logger.debug("Downloading {} to {}", (Object)url, (Object)dst.getAbsolutePath());
                return Either.right((Object)Option.some((Object)WorkspaceImpl.downloadTo(response, dst)));
            }
        }
        logger.warn("Received unexpected response status {} while trying to download from {}", (Object)status, (Object)url);
        FileUtils.deleteQuietly((File)dst);
        return Either.right((Object)Option.none(File.class));
    }

    private HttpGet createGetRequest(URI src, File dst, Map<String, String> params) throws IOException {
        try {
            URIBuilder builder = new URIBuilder(src.toString());
            for (Map.Entry<String, String> param : params.entrySet()) {
                builder.setParameter(param.getKey(), param.getValue());
            }
            HttpGet get = new HttpGet(builder.build());
            if (dst.isFile() && dst.length() > 0L) {
                get.setHeader("If-None-Match", this.md5(dst));
            }
            return get;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadIfNecessary(URI src, File dst) throws IOException, NotFoundException {
        HttpGet get = this.createGetRequest(src, dst, Collections.emptyMap());
        try {
            block5: while (true) {
                Either<String, Option<File>> result;
                HttpResponse response = null;
                try {
                    response = this.trustedHttpClient.execute((HttpUriRequest)get);
                    result = this.handleDownloadResponse(response, src, dst);
                }
                finally {
                    if (response != null) {
                        this.trustedHttpClient.close(response);
                    }
                }
                Iterator iterator = result.right().iterator();
                if (iterator.hasNext()) {
                    Option ff = (Option)iterator.next();
                    Iterator iterator2 = ff.iterator();
                    if (iterator2.hasNext()) {
                        File f = (File)iterator2.next();
                        return f;
                    }
                    FileUtils.deleteQuietly((File)dst);
                    throw new NotFoundException();
                }
                iterator = result.left().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    String token = (String)iterator.next();
                    get = this.createGetRequest(src, dst, Collections.singletonMap("token", token));
                    Prelude.sleep((long)60000L);
                }
                break;
            }
        }
        catch (TrustedHttpClientException e) {
            FileUtils.deleteQuietly((File)dst);
            throw new NotFoundException(String.format("Could not copy %s to %s", src, dst.getAbsolutePath()), (Throwable)e);
        }
    }

    private Function<File, File> downloadIfNecessary(final URI src) {
        return new Function.X<File, File>(){

            public File xapply(File dst) throws Exception {
                return WorkspaceImpl.this.downloadIfNecessary(src, dst);
            }
        };
    }

    private static File downloadTo(HttpResponse response, File dst) throws IOException {
        dst.createNewFile();
        try (InputStream in = response.getEntity().getContent();
             FileOutputStream out = new FileOutputStream(dst);){
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        return dst;
    }

    protected String md5(File file) throws IOException, IllegalArgumentException, IllegalStateException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " can not be read");
        }
        try (FileInputStream in = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)in);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI uri) throws NotFoundException, IOException {
        File f;
        String uriPath = uri.toString();
        String[] uriElements = uriPath.split("/");
        String collectionId = null;
        boolean isMediaPackage = false;
        logger.trace("delete {}", (Object)uriPath);
        if (uriPath.startsWith(this.wfr.getBaseUri().toString())) {
            if (uriPath.indexOf("/collection/") > 0) {
                if (uriElements.length > 2) {
                    collectionId = uriElements[uriElements.length - 2];
                    String filename = uriElements[uriElements.length - 1];
                    this.wfr.deleteFromCollection(collectionId, filename);
                }
            } else if (uriPath.indexOf("/mediapackage/") > 0) {
                isMediaPackage = true;
                if (uriElements.length >= 3) {
                    String mediaPackageId = uriElements[uriElements.length - 3];
                    String elementId = uriElements[uriElements.length - 2];
                    this.wfr.delete(mediaPackageId, elementId);
                }
            }
        }
        if ((f = this.toWorkspaceFile(uri)).isFile()) {
            Object object = this.lock;
            synchronized (object) {
                File mpElementDir = f.getParentFile();
                FileUtils.forceDelete((File)f);
                if (isMediaPackage || !this.isStaticCollection(collectionId)) {
                    FileSupport.delete((File)mpElementDir);
                }
                if (isMediaPackage) {
                    FileSupport.delete((File)mpElementDir.getParentFile());
                }
            }
        }
        this.waitForResource(uri, 404, "File %s does not disappear in WFR");
    }

    public void delete(String mediaPackageID, String mediaPackageElementID) throws NotFoundException, IOException {
        File f = this.workspaceFile("/mediapackage/", mediaPackageID, mediaPackageElementID);
        FileUtils.deleteQuietly((File)f);
        FileSupport.delete((File)f.getParentFile());
        this.wfr.delete(mediaPackageID, mediaPackageElementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI put(String mediaPackageID, String mediaPackageElementID, String fileName, InputStream in) throws IOException {
        String safeFileName = this.toSafeName(fileName);
        URI uri = this.wfr.getURI(mediaPackageID, mediaPackageElementID, fileName);
        RequireUtil.notNull((Object)in, (String)"in");
        File workspaceFile = null;
        Object object = this.lock;
        synchronized (object) {
            workspaceFile = this.toWorkspaceFile(uri);
            FileUtils.touch((File)workspaceFile);
        }
        if (this.linkingEnabled) {
            this.wfr.put(mediaPackageID, mediaPackageElementID, fileName, in);
            File workingFileRepoDirectory = this.workingFileRepositoryFile("/mediapackage/", mediaPackageID, mediaPackageElementID);
            File workingFileRepoCopy = new File(workingFileRepoDirectory, safeFileName);
            FileSupport.link((File)workingFileRepoCopy, (File)workspaceFile, (boolean)true);
        } else {
            try (FileOutputStream out = new FileOutputStream(workspaceFile);
                 TeeInputStream tee = new TeeInputStream(in, (OutputStream)out, true);){
                this.wfr.put(mediaPackageID, mediaPackageElementID, fileName, (InputStream)tee);
            }
        }
        this.waitForResource(uri, 200, "File %s does not appear in WFR");
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI putInCollection(String collectionId, String fileName, InputStream in) throws IOException {
        FileOutputStream out;
        InputStream tee;
        URI uri;
        block8: {
            String safeFileName = this.toSafeName(fileName);
            uri = this.wfr.getCollectionURI(collectionId, fileName);
            tee = null;
            File tempFile = null;
            out = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    tempFile = this.toWorkspaceFile(uri);
                    FileUtils.touch((File)tempFile);
                    out = new FileOutputStream(tempFile);
                }
                if (this.linkingEnabled) {
                    tee = in;
                    this.wfr.putInCollection(collectionId, fileName, tee);
                    FileUtils.forceMkdir((File)tempFile.getParentFile());
                    File workingFileRepoDirectory = this.workingFileRepositoryFile("/collection/", collectionId);
                    File workingFileRepoCopy = new File(workingFileRepoDirectory, safeFileName);
                    FileSupport.link((File)workingFileRepoCopy, (File)tempFile, (boolean)true);
                    break block8;
                }
                tee = new TeeInputStream(in, (OutputStream)out, true);
                this.wfr.putInCollection(collectionId, fileName, tee);
            }
            catch (IOException e) {
                try {
                    FileUtils.deleteQuietly(tempFile);
                    throw e;
                }
                catch (Throwable throwable) {
                    IoSupport.closeQuietly(tee);
                    IoSupport.closeQuietly(out);
                    throw throwable;
                }
            }
        }
        IoSupport.closeQuietly((Closeable)tee);
        IoSupport.closeQuietly((Closeable)out);
        this.waitForResource(uri, 200, "File %s does not appear in WFR");
        return uri;
    }

    public URI getURI(String mediaPackageID, String mediaPackageElementID) {
        return this.wfr.getURI(mediaPackageID, mediaPackageElementID);
    }

    public URI getCollectionURI(String collectionID, String fileName) {
        return this.wfr.getCollectionURI(collectionID, fileName);
    }

    public URI moveTo(URI collectionURI, String toMediaPackage, String toMediaPackageElement, String toFileName) throws NotFoundException, IOException {
        String path = collectionURI.toString();
        String filename = FilenameUtils.getName((String)path);
        String collection = this.getCollection(collectionURI);
        logger.debug("Moving {} from {} to {}/{}", new Object[]{filename, collection, toMediaPackage, toMediaPackageElement});
        File original = this.toWorkspaceFile(collectionURI);
        if (original.isFile()) {
            URI copyURI = this.wfr.getURI(toMediaPackage, toMediaPackageElement, toFileName);
            File copy = this.toWorkspaceFile(copyURI);
            FileUtils.forceMkdir((File)copy.getParentFile());
            FileUtils.deleteQuietly((File)copy);
            FileUtils.moveFile((File)original, (File)copy);
            if (!this.isStaticCollection(collection)) {
                FileSupport.delete((File)original.getParentFile());
            }
        }
        URI wfrUri = this.wfr.moveTo(collection, filename, toMediaPackage, toMediaPackageElement, toFileName);
        this.waitForResource(wfrUri, 200, "File %s does not appear in WFR");
        return wfrUri;
    }

    public URI[] getCollectionContents(String collectionId) throws NotFoundException {
        return this.wfr.getCollectionContents(collectionId);
    }

    private void deleteFromCollection(String collectionId, String fileName, boolean removeCollection) throws NotFoundException, IOException {
        File f = this.workspaceFile("/collection/", collectionId, this.toSafeName(fileName));
        FileUtils.deleteQuietly((File)f);
        if (removeCollection) {
            FileSupport.delete((File)f.getParentFile());
        }
        try {
            this.wfr.deleteFromCollection(collectionId, fileName, removeCollection);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException((Throwable)e);
        }
        this.waitForResource(this.wfr.getCollectionURI(collectionId, fileName), 404, "File %s does not disappear in WFR");
    }

    public void deleteFromCollection(String collectionId, String fileName) throws NotFoundException, IOException {
        this.deleteFromCollection(collectionId, fileName, false);
    }

    File toWorkspaceFile(URI uri) {
        String uriString = UriBuilder.fromUri((URI)uri).replaceQuery(null).build(new Object[0]).toString();
        String wfrPrefix = this.wfr.getBaseUri().toString();
        String serverPath = FilenameUtils.getPath((String)uriString);
        serverPath = uriString.startsWith(wfrPrefix) ? serverPath.substring(wfrPrefix.length()) : serverPath.replaceAll(":/*", "_");
        String wsDirectoryPath = PathSupport.concat((String)this.wsRoot, (String)serverPath);
        File wsDirectory = new File(wsDirectoryPath);
        wsDirectory.mkdirs();
        String safeFileName = this.toSafeName(FilenameUtils.getName((String)uriString));
        if (StringUtils.isBlank((CharSequence)safeFileName)) {
            safeFileName = UNKNOWN_FILENAME;
        }
        return new File(wsDirectory, safeFileName);
    }

    private File workspaceFile(String ... path) {
        return new File(PathSupport.path((String[])((String[])Arrays.cons(String.class, (Object)this.wsRoot, (Object[])path))));
    }

    private File workingFileRepositoryFile(String ... path) {
        return new File(PathSupport.path((String[])((String[])Arrays.cons(String.class, (Object)this.pathMappable.getPathPrefix(), (Object[])path))));
    }

    private String getCollection(URI uri) {
        String path = uri.toString();
        if (path.indexOf("/collection/") < 0) {
            throw new IllegalArgumentException(String.valueOf(uri) + " must point to a working file repository collection");
        }
        String collection = FilenameUtils.getPath((String)path);
        if (collection.endsWith("/")) {
            collection = collection.substring(0, collection.length() - 1);
        }
        collection = collection.substring(collection.lastIndexOf("/"));
        collection = collection.substring(collection.lastIndexOf("/") + 1, collection.length());
        return collection;
    }

    private boolean isStaticCollection(String collection) {
        return this.staticCollections.contains(collection);
    }

    public Option<Long> getTotalSpace() {
        return Option.some((Object)new File(this.wsRoot).getTotalSpace());
    }

    public Option<Long> getUsableSpace() {
        return Option.some((Object)new File(this.wsRoot).getUsableSpace());
    }

    public Option<Long> getUsedSpace() {
        return Option.some((Object)FileUtils.sizeOfDirectory((File)new File(this.wsRoot)));
    }

    public URI getBaseUri() {
        return this.wfr.getBaseUri();
    }

    @Reference
    public void setRepository(WorkingFileRepository repo) {
        this.wfr = repo;
        if (repo instanceof PathMappable) {
            this.pathMappable = (PathMappable)repo;
            logger.info("Mapping workspace to working file repository using {}", (Object)this.pathMappable.getPathPrefix());
        }
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        this.trustedHttpClient = trustedHttpClient;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    private void waitForResource(final URI uri, final int expectedStatus, final String errorMsg) throws IOException {
        if (this.waitForResourceFlag) {
            HttpUtil.waitForResource((TrustedHttpClient)this.trustedHttpClient, (URI)uri, (int)expectedStatus, (long)120000L, (long)1000L).fold(Misc.chuck(), (Function)new Effect.X<Integer>(this){

                public void xrun(Integer status) throws Exception {
                    if (EqualsUtil.ne((Object)status, (Object)expectedStatus)) {
                        String msg = String.format(errorMsg, uri.toString());
                        logger.warn(msg);
                        throw new IOException(msg);
                    }
                }
            });
        }
    }

    public void cleanup(int maxAgeInSeconds) {
        if (maxAgeInSeconds < 0) {
            logger.debug("Canceling cleanup of workspace due to maxAge ({}) <= 0", (Object)maxAgeInSeconds);
            return;
        }
        if (maxAgeInSeconds < 172800) {
            logger.warn("The max age for the workspace cleaner is dangerously low. Please consider increasing the value to avoid deleting data in use by running workflows.");
        }
        RecursiveDirectoryCleaner.cleanDirectory((Path)Paths.get(this.wsRoot, new String[0]), (Duration)Duration.ofSeconds(maxAgeInSeconds));
    }

    public void cleanup(Id mediaPackageId) throws IOException {
        this.cleanup(mediaPackageId, false);
    }

    public void cleanup(Id mediaPackageId, boolean filesOnly) throws IOException {
        File mediaPackageDir = this.workspaceFile("/mediapackage/", mediaPackageId.toString());
        if (filesOnly) {
            logger.debug("Clean workspace media package directory {} (files only)", (Object)mediaPackageDir);
            FileSupport.delete((File)mediaPackageDir, (int)0);
        } else {
            logger.debug("Clean workspace media package directory {}", (Object)mediaPackageDir);
            FileUtils.deleteDirectory((File)mediaPackageDir);
        }
    }

    public String rootDirectory() {
        return this.wsRoot;
    }

    private class DeleteOnCloseFileInputStream
    extends FileInputStream {
        private File file;

        DeleteOnCloseFileInputStream(WorkspaceImpl workspaceImpl, File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file != null) {
                    logger.debug("Cleaning up {}", (Object)this.file);
                    this.file.delete();
                    this.file = null;
                }
            }
        }
    }
}

