/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.ArrayList;
import java.util.List;
import org.opencastproject.mediapackage.Track;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowOperationTagUtil {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowOperationTagUtil.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";

    private WorkflowOperationTagUtil() {
    }

    public static TagDiff createTagDiff(List<String> tagList) {
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        if (tagList != null) {
            for (String tag : tagList) {
                if (tag.startsWith(MINUS)) {
                    removeTags.add(tag);
                    continue;
                }
                if (tag.startsWith(PLUS)) {
                    addTags.add(tag);
                    continue;
                }
                overrideTags.add(tag);
            }
        }
        return new TagDiff(removeTags, addTags, overrideTags);
    }

    public static void applyTagDiff(TagDiff td, Track t) {
        if (!td.overrideTags.isEmpty()) {
            t.clearTags();
            for (String tag : td.overrideTags) {
                logger.trace("Tagging composed track with '{}'", (Object)tag);
                t.addTag(tag);
            }
        } else {
            for (String tag : td.removeTags) {
                logger.trace("Remove tagging '{}' from composed track", (Object)tag);
                t.removeTag(tag.substring(MINUS.length()));
            }
            for (String tag : td.addTags) {
                logger.trace("Add tagging '{}' to composed track", (Object)tag);
                t.addTag(tag.substring(PLUS.length()));
            }
        }
    }

    public static class TagDiff {
        private final List<String> removeTags;
        private final List<String> addTags;
        private final List<String> overrideTags;

        TagDiff(List<String> removeTags, List<String> addTags, List<String> overrideTags) {
            this.removeTags = removeTags;
            this.addTags = addTags;
            this.overrideTags = overrideTags;
        }
    }
}

