/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.User;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="WorkflowInstance")
@Access(value=AccessType.FIELD)
@Table(name="oc_workflow", indexes={@Index(name="IX_oc_workflow_mediapackage_id", columnList="mediapackage_id"), @Index(name="IX_oc_workflow_series_id", columnList="series_id")})
@NamedQueries(value={@NamedQuery(name="Workflow.findAll", query="select w from WorkflowInstance w where w.organizationId=:organizationId order by w.dateCreated"), @NamedQuery(name="Workflow.countLatest", query="SELECT COUNT(DISTINCT w.mediaPackageId) FROM WorkflowInstance w"), @NamedQuery(name="Workflow.findAllOrganizationIndependent", query="select w from WorkflowInstance w"), @NamedQuery(name="Workflow.workflowById", query="SELECT w FROM WorkflowInstance as w where w.workflowId=:workflowId and w.organizationId=:organizationId"), @NamedQuery(name="Workflow.workflowByIdOrganizationIndependent", query="SELECT w FROM WorkflowInstance as w where w.workflowId=:workflowId"), @NamedQuery(name="Workflow.getCount", query="select COUNT(w) from WorkflowInstance w where w.organizationId=:organizationId and (:state is null or w.state = :state) "), @NamedQuery(name="Workflow.toCleanup", query="SELECT w FROM WorkflowInstance w where w.state = :state and w.dateCreated < :dateCreated and w.organizationId = :organizationId"), @NamedQuery(name="Workflow.byMediaPackage", query="SELECT w FROM WorkflowInstance w where w.mediaPackageId = :mediaPackageId and w.organizationId = :organizationId order by w.dateCreated"), @NamedQuery(name="Workflow.countActiveByMediaPackage", query="SELECT COUNT(w) FROM WorkflowInstance w where w.mediaPackageId = :mediaPackageId and w.organizationId = :organizationId and (w.state = :stateInstantiated or w.state = :statePaused or w.state = :stateRunning or w.state = :stateFailing)"), @NamedQuery(name="Workflow.byMediaPackageAndActive", query="SELECT w FROM WorkflowInstance w where w.mediaPackageId = :mediaPackageId and w.organizationId = :organizationId and (w.state = :stateInstantiated or w.state = :statePaused or w.state = :stateRunning or w.state = :stateFailing) order by w.dateCreated"), @NamedQuery(name="Workflow.countActiveByUser", query="SELECT COUNT(w) FROM WorkflowInstance w where w.creatorName = :userId and w.organizationId = :organizationId and (w.state = :stateInstantiated or w.state = :statePaused or w.state = :stateRunning or w.state = :stateFailing)")})
public class WorkflowInstance {
    @Id
    @Column(name="id")
    private long workflowId;
    @Column(name="state", length=128)
    private WorkflowState state;
    @Column(name="template")
    private String template;
    @Column(name="title")
    private String title;
    @Column(name="description")
    @Lob
    private String description;
    @Column(name="creator_id")
    private String creatorName;
    @Column(name="organization_id")
    private String organizationId;
    @Column(name="date_created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreated = null;
    @Column(name="date_completed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCompleted = null;
    @Lob
    @Column(name="mediapackage", length=0xFFFFFF)
    private String mediaPackage;
    @Transient
    private MediaPackage mediaPackageObj;
    @OneToMany(mappedBy="instance", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @OrderColumn(name="position")
    protected List<WorkflowOperationInstance> operations;
    @ElementCollection
    @CollectionTable(name="oc_workflow_configuration", joinColumns={@JoinColumn(name="workflow_id")}, indexes={@Index(name="IX_oc_workflow_configuration_workflow_id", columnList="workflow_id")})
    @MapKeyColumn(name="configuration_key")
    @Lob
    @Column(name="configuration_value")
    protected Map<String, String> configurations;
    @Column(name="mediapackage_id", length=128)
    protected String mediaPackageId;
    @Column(name="series_id", length=128)
    protected String seriesId;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInstance.class);

    public WorkflowInstance() {
    }

    public WorkflowInstance(WorkflowDefinition def, MediaPackage mediaPackage, User creator, Organization organization, Map<String, String> configuration) {
        this.workflowId = -1L;
        this.title = def.getTitle();
        this.template = def.getId();
        this.description = def.getDescription();
        this.creatorName = creator != null ? creator.getUsername() : null;
        this.organizationId = organization != null ? organization.getId() : null;
        this.state = WorkflowState.INSTANTIATED;
        this.dateCreated = new Date();
        this.mediaPackageObj = mediaPackage;
        this.mediaPackage = mediaPackage == null ? null : MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
        this.mediaPackageId = mediaPackage == null ? null : mediaPackage.getIdentifier().toString();
        this.seriesId = mediaPackage == null ? null : mediaPackage.getSeries();
        this.operations = new ArrayList<WorkflowOperationInstance>();
        this.extend(def);
        this.configurations = new HashMap<String, String>();
        if (configuration != null) {
            this.configurations.putAll(configuration);
        }
    }

    public WorkflowInstance(long id, WorkflowState state, String template, String title, String description, String creatorName, String organizationId, Date dateCreated, Date dateCompleted, MediaPackage mediaPackage, List<WorkflowOperationInstance> operations, Map<String, String> configurations, String mediaPackageId, String seriesId) {
        this.workflowId = id;
        this.state = state;
        this.template = template;
        this.title = title;
        this.description = description;
        this.creatorName = creatorName;
        this.organizationId = organizationId;
        this.dateCreated = dateCreated;
        this.dateCompleted = dateCompleted;
        this.mediaPackageObj = mediaPackage;
        this.mediaPackage = mediaPackage == null ? null : MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
        this.operations = operations;
        this.configurations = configurations;
        this.mediaPackageId = mediaPackageId;
        this.seriesId = seriesId;
    }

    public long getId() {
        return this.workflowId;
    }

    public void setId(long workflowId) {
        this.workflowId = workflowId;
    }

    public WorkflowState getState() {
        return this.state;
    }

    public void setState(WorkflowState state) {
        if (this.dateCompleted == null && state.isTerminated()) {
            this.dateCompleted = new Date();
        }
        this.state = state;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public MediaPackage getMediaPackage() {
        try {
            if (this.mediaPackageObj != null) {
                return this.mediaPackageObj;
            }
            if (this.mediaPackage != null) {
                this.mediaPackageObj = MediaPackageParser.getFromXml((String)this.mediaPackage);
                return this.mediaPackageObj;
            }
        }
        catch (MediaPackageException e) {
            logger.error("Error parsing media package in workflow instance", (Throwable)e);
        }
        return null;
    }

    public void setMediaPackage(MediaPackage mediaPackage) {
        this.mediaPackageObj = mediaPackage;
        this.mediaPackage = mediaPackage == null ? null : MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
        this.mediaPackageId = mediaPackage == null ? null : mediaPackage.getIdentifier().toString();
        this.seriesId = mediaPackage == null ? null : mediaPackage.getSeries();
    }

    public boolean isActive() {
        return !this.getState().isTerminated();
    }

    public List<WorkflowOperationInstance> getOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationInstance>();
        }
        return this.operations;
    }

    public final void setOperations(List<WorkflowOperationInstance> workflowOperationInstanceList) {
        for (WorkflowOperationInstance workflowOperationInstance : workflowOperationInstanceList) {
            workflowOperationInstance.setWorkflowInstance(this);
        }
        this.operations = workflowOperationInstanceList;
    }

    public WorkflowOperationInstance getCurrentOperation() {
        logger.debug("operations: {}", this.operations);
        if (this.operations == null) {
            return null;
        }
        List<WorkflowOperationInstance.OperationState> currentStates = List.of(WorkflowOperationInstance.OperationState.RUNNING, WorkflowOperationInstance.OperationState.PAUSED, WorkflowOperationInstance.OperationState.RETRY, WorkflowOperationInstance.OperationState.INSTANTIATED);
        for (WorkflowOperationInstance operation : this.operations) {
            if (!currentStates.contains((Object)operation.getState())) continue;
            logger.debug("current operation: {}", (Object)operation);
            return operation;
        }
        return null;
    }

    public Map<String, String> getConfigurations() {
        if (this.configurations == null) {
            return Collections.emptyMap();
        }
        return this.configurations;
    }

    public String getConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return null;
        }
        return this.configurations.get(key);
    }

    public Set<String> getConfigurationKeys() {
        if (this.configurations == null) {
            return Collections.emptySet();
        }
        return this.configurations.keySet();
    }

    public void removeConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return;
        }
        this.configurations.remove(key);
    }

    public void setConfiguration(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.configurations == null) {
            this.configurations = new TreeMap<String, String>();
        }
        this.configurations.put(key, value);
    }

    public int hashCode() {
        return Long.valueOf(this.workflowId).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkflowInstance) {
            WorkflowInstance other = (WorkflowInstance)obj;
            return this.workflowId == other.getId();
        }
        return false;
    }

    public String toString() {
        return "Workflow {" + this.workflowId + "}";
    }

    public void extend(WorkflowDefinition workflowDefinition) {
        for (WorkflowOperationDefinition operation : workflowDefinition.getOperations()) {
            WorkflowOperationInstance operationInstance = new WorkflowOperationInstance(operation);
            operationInstance.setWorkflowInstance(this);
            this.operations.add(operationInstance);
        }
        this.setTemplate(workflowDefinition.getId());
    }

    public void insert(WorkflowDefinition workflowDefinition, WorkflowOperationInstance after) {
        int index = this.operations.indexOf(after) + 1;
        for (WorkflowOperationDefinition operation : workflowDefinition.getOperations()) {
            WorkflowOperationInstance operationInstance = new WorkflowOperationInstance(operation);
            operationInstance.setWorkflowInstance(this);
            this.operations.add(index, operationInstance);
            ++index;
        }
    }

    public static enum WorkflowState {
        INSTANTIATED,
        RUNNING,
        STOPPED,
        PAUSED,
        SUCCEEDED,
        FAILED,
        FAILING;


        public boolean isTerminated() {
            switch (this.ordinal()) {
                case 2: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }

        public static class Adapter
        extends XmlAdapter<String, WorkflowState> {
            public String marshal(WorkflowState workflowState) {
                return workflowState == null ? null : workflowState.toString().toLowerCase();
            }

            public WorkflowState unmarshal(String val) {
                return val == null ? null : WorkflowState.valueOf(val.toUpperCase());
            }
        }
    }
}

