/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.ArrayList;
import java.util.List;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredTagsAndFlavors {
    private List<String> srcTags = new ArrayList<String>();
    private List<String> targetTags = new ArrayList<String>();
    private List<MediaPackageElementFlavor> srcFlavors = new ArrayList<MediaPackageElementFlavor>();
    private List<MediaPackageElementFlavor> targetFlavors = new ArrayList<MediaPackageElementFlavor>();
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredTagsAndFlavors.class);

    protected ConfiguredTagsAndFlavors() {
    }

    public List<String> getSrcTags() {
        return this.srcTags;
    }

    public List<String> getTargetTags() {
        return this.targetTags;
    }

    public List<MediaPackageElementFlavor> getSrcFlavors() {
        return this.srcFlavors;
    }

    public List<MediaPackageElementFlavor> getTargetFlavors() {
        return this.targetFlavors;
    }

    public String getSingleSrcTag() {
        if (this.srcTags.isEmpty()) {
            throw new IllegalStateException("No source-tag was configured!");
        }
        if (this.srcTags.size() > 1) {
            throw new IllegalStateException("More than one source-tag was configured!");
        }
        return this.srcTags.get(0);
    }

    public String getSingleTargetTag() {
        if (this.targetTags.isEmpty()) {
            throw new IllegalStateException("No target-tag was configured!");
        }
        if (this.targetTags.size() > 1) {
            throw new IllegalStateException("More than one target-tag was configured!");
        }
        return this.targetTags.get(0);
    }

    public MediaPackageElementFlavor getSingleSrcFlavor() {
        if (this.srcFlavors.isEmpty()) {
            throw new IllegalStateException("No source-flavor was configured!");
        }
        if (this.srcFlavors.size() > 1) {
            throw new IllegalStateException("More than one source-flavor was configured!");
        }
        return this.srcFlavors.get(0);
    }

    public MediaPackageElementFlavor getSingleTargetFlavor() {
        if (this.targetFlavors.isEmpty()) {
            throw new IllegalStateException("No target-flavor was configured!");
        }
        if (this.targetFlavors.size() > 1) {
            throw new IllegalStateException("More than one target-flavor was configured!");
        }
        return this.targetFlavors.get(0);
    }

    protected void setSrcTags(List<String> srcTags) {
        this.srcTags = srcTags;
        logger.debug("Added " + srcTags.size() + " elements to srcTags list");
    }

    protected void setTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        logger.debug("Added " + targetTags.size() + " elements to targetTags list");
    }

    protected void setSrcFlavors(List<MediaPackageElementFlavor> srcFlavors) {
        this.srcFlavors = srcFlavors;
        logger.debug("Added " + srcFlavors.size() + " elements to srcFlavors list");
    }

    protected void setTargetFlavors(List<MediaPackageElementFlavor> targetFlavors) {
        this.targetFlavors = targetFlavors;
        logger.debug("Added " + targetFlavors.size() + " elements to targetFlavors list");
    }
}

