/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowStateException;

public interface WorkflowService {
    public static final String WORKFLOW_OPERATION_PROPERTY = "workflow.operation";
    public static final String JOB_TYPE = "org.opencastproject.workflow";

    public void addWorkflowListener(WorkflowListener var1);

    public void removeWorkflowListener(WorkflowListener var1);

    public WorkflowDefinition getWorkflowDefinitionById(String var1) throws WorkflowDatabaseException, NotFoundException;

    public WorkflowInstance getWorkflowById(long var1) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException;

    public WorkflowInstance start(WorkflowDefinition var1, MediaPackage var2, Map<String, String> var3) throws WorkflowDatabaseException, WorkflowParsingException, UnauthorizedException;

    public WorkflowInstance start(WorkflowDefinition var1, MediaPackage var2, Long var3, Map<String, String> var4) throws WorkflowDatabaseException, WorkflowParsingException, UnauthorizedException, NotFoundException, IllegalStateException;

    public WorkflowInstance start(WorkflowDefinition var1, MediaPackage var2) throws WorkflowDatabaseException, WorkflowParsingException, UnauthorizedException;

    public long countWorkflowInstances() throws WorkflowDatabaseException;

    public long countWorkflowInstances(WorkflowInstance.WorkflowState var1) throws WorkflowDatabaseException;

    public WorkflowInstance stop(long var1) throws WorkflowException, NotFoundException, UnauthorizedException;

    public void remove(long var1) throws WorkflowDatabaseException, WorkflowParsingException, NotFoundException, UnauthorizedException, WorkflowStateException;

    public void remove(long var1, boolean var3) throws WorkflowDatabaseException, WorkflowParsingException, NotFoundException, UnauthorizedException, WorkflowStateException;

    public WorkflowInstance suspend(long var1) throws WorkflowException, NotFoundException, UnauthorizedException;

    public WorkflowInstance resume(long var1) throws NotFoundException, WorkflowException, IllegalStateException, UnauthorizedException;

    public WorkflowInstance resume(long var1, Map<String, String> var3) throws NotFoundException, WorkflowException, IllegalStateException, UnauthorizedException;

    public void update(WorkflowInstance var1) throws WorkflowDatabaseException, UnauthorizedException;

    public List<WorkflowDefinition> listAvailableWorkflowDefinitions() throws WorkflowDatabaseException;

    public void cleanupWorkflowInstances(int var1, WorkflowInstance.WorkflowState var2) throws WorkflowDatabaseException, UnauthorizedException;

    public Map<String, Map<String, String>> getWorkflowStateMappings();

    public boolean mediaPackageHasActiveWorkflows(String var1) throws WorkflowDatabaseException;

    public boolean userHasActiveWorkflows(String var1) throws WorkflowDatabaseException;

    public List<WorkflowInstance> getWorkflowInstancesByMediaPackage(String var1) throws WorkflowDatabaseException, UnauthorizedException;

    public Optional<WorkflowInstance> getRunningWorkflowInstanceByMediaPackage(String var1, String var2) throws WorkflowException, UnauthorizedException, WorkflowDatabaseException;
}

