/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opencastproject.workflow.api.JaxbWorkflowConfiguration;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;

@XmlType(name="operation-definition", namespace="http://workflow.opencastproject.org")
@XmlRootElement(name="operation-definition", namespace="http://workflow.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WorkflowOperationDefinitionImpl
implements WorkflowOperationDefinition {
    @XmlAttribute(name="id")
    protected String id;
    @XmlAttribute(name="description")
    protected String description;
    @XmlAttribute(name="fail-on-error")
    protected boolean failWorkflowOnException = true;
    @XmlAttribute(name="if")
    protected String executeCondition;
    @XmlAttribute(name="unless")
    protected String skipCondition;
    @XmlAttribute(name="exception-handler-workflow")
    protected String exceptionHandlingWorkflow;
    @XmlElement(name="configuration")
    @XmlElementWrapper(name="configurations")
    protected Set<JaxbWorkflowConfiguration> configurations;
    @XmlAttribute(name="max-attempts")
    protected int maxAttempts = 1;
    @XmlJavaTypeAdapter(value=RetryStrategy.Adapter.class)
    @XmlAttribute(name="retry-strategy")
    protected RetryStrategy retryStrategy = RetryStrategy.NONE;

    public WorkflowOperationDefinitionImpl() {
    }

    public WorkflowOperationDefinitionImpl(String id, String description, String exceptionHandlingWorkflow, boolean failWorkflowOnException) {
        this();
        this.id = id;
        this.description = description;
        this.exceptionHandlingWorkflow = exceptionHandlingWorkflow;
        this.failWorkflowOnException = failWorkflowOnException;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionCondition(String condition) {
        this.executeCondition = condition;
    }

    @Override
    public String getExecutionCondition() {
        return this.executeCondition;
    }

    public void setSkipCondition(String condition) {
        this.skipCondition = condition;
    }

    @Override
    public String getSkipCondition() {
        return this.skipCondition;
    }

    @Override
    public String getExceptionHandlingWorkflow() {
        return this.exceptionHandlingWorkflow;
    }

    public void setExceptionHandlingWorkflow(String exceptionHandlingWorkflow) {
        this.exceptionHandlingWorkflow = exceptionHandlingWorkflow;
    }

    @Override
    public boolean isFailWorkflowOnException() {
        return this.failWorkflowOnException;
    }

    public void setFailWorkflowOnException(boolean failWorkflowOnException) {
        this.failWorkflowOnException = failWorkflowOnException;
    }

    @Override
    public String getConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return null;
        }
        for (JaxbWorkflowConfiguration config : this.configurations) {
            if (!config.getKey().equals(key)) continue;
            return config.getValue();
        }
        return null;
    }

    @Override
    public void removeConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return;
        }
        Iterator<JaxbWorkflowConfiguration> configIter = this.configurations.iterator();
        while (configIter.hasNext()) {
            JaxbWorkflowConfiguration config = configIter.next();
            if (!config.getKey().equals(key)) continue;
            configIter.remove();
            return;
        }
    }

    @Override
    public void setConfiguration(String key, String value) {
        if (key == null || this.configurations == null) {
            return;
        }
        for (JaxbWorkflowConfiguration config : this.configurations) {
            if (!config.getKey().equals(key)) continue;
            config.setValue(value);
            return;
        }
        this.configurations.add(new JaxbWorkflowConfiguration(key, value));
    }

    @Override
    public Set<String> getConfigurationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        if (this.configurations != null) {
            for (JaxbWorkflowConfiguration config : this.configurations) {
                set.add(config.getKey());
            }
        }
        return set;
    }

    @Override
    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public String toString() {
        return "operation definition:'" + this.id + "'";
    }

    static class Adapter
    extends XmlAdapter<WorkflowOperationDefinitionImpl, WorkflowOperationDefinition> {
        Adapter() {
        }

        public WorkflowOperationDefinitionImpl marshal(WorkflowOperationDefinition op) throws Exception {
            return (WorkflowOperationDefinitionImpl)op;
        }

        public WorkflowOperationDefinition unmarshal(WorkflowOperationDefinitionImpl op) throws Exception {
            return op;
        }
    }
}

