/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.conditionparser;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.workflow.conditionparser.WorkflowConditionBooleanInterpreter;
import org.opencastproject.workflow.conditionparser.antlr.WorkflowConditionLexer;
import org.opencastproject.workflow.conditionparser.antlr.WorkflowConditionParser;

public final class WorkflowConditionInterpreter {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(?<varname>[^:}]+)(:(?<def>[^}]+))?}");

    private WorkflowConditionInterpreter() {
    }

    public static String replaceVariables(String source, Function<String, String> systemPropertyGetter, Map<String, String> properties, boolean quoteStrings) {
        if (source == null) {
            return null;
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(source);
        StringBuilder result = new StringBuilder();
        int cursor = 0;
        boolean matchFound = matcher.find();
        if (!matchFound) {
            return source;
        }
        while (matchFound) {
            int matchEnd;
            block11: {
                String toAppend;
                int matchStart = matcher.start();
                matchEnd = matcher.end();
                result.append(source, cursor, matchStart);
                String key = matcher.group("varname");
                String systemProperty = systemPropertyGetter.apply(key);
                String providedProperty = null;
                if (properties != null) {
                    providedProperty = properties.get(key);
                }
                if ((toAppend = StringUtils.isNotBlank(providedProperty) ? providedProperty : (StringUtils.isNotBlank((CharSequence)systemProperty) ? systemProperty : null)) != null) {
                    if (!quoteStrings) {
                        result.append(toAppend);
                    } else {
                        try {
                            if ("false".equals(toAppend) || "true".equals(toAppend)) {
                                result.append(toAppend);
                                break block11;
                            }
                            Float.parseFloat(toAppend);
                            result.append(toAppend);
                        }
                        catch (NumberFormatException e) {
                            result.append("'").append(toAppend.replace("''", "'")).append("'");
                        }
                    }
                } else {
                    result.append(source, matchStart, matchEnd);
                }
            }
            cursor = matchEnd;
            matchFound = matcher.find();
            if (matchFound) continue;
            result.append(source.substring(matchEnd));
        }
        return result.toString();
    }

    static String replaceDefaults(String source) {
        Matcher matcher = PROPERTY_PATTERN.matcher(source);
        StringBuilder result = new StringBuilder();
        int cursor = 0;
        boolean matchFound = matcher.find();
        if (!matchFound) {
            return source;
        }
        while (matchFound) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            result.append(source, cursor, matchStart);
            String defaultValue = matcher.group("def");
            if (defaultValue == null) {
                defaultValue = "false";
            }
            result.append(defaultValue);
            cursor = matchEnd;
            matchFound = matcher.find();
            if (matchFound) continue;
            result.append(source.substring(matchEnd));
        }
        return result.toString();
    }

    public static boolean interpret(String input) throws IllegalArgumentException {
        String s = WorkflowConditionInterpreter.replaceDefaults(input);
        WorkflowConditionLexer l = new WorkflowConditionLexer(CharStreams.fromString(s));
        l.removeErrorListeners();
        BaseErrorListener listener = new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
                throw new IllegalArgumentException("line " + line + ":" + charPositionInLine + " " + msg);
            }
        };
        WorkflowConditionParser p = new WorkflowConditionParser(new CommonTokenStream(l));
        p.removeErrorListeners();
        p.addErrorListener(listener);
        WorkflowConditionParser.BooleanExpressionContext tree = p.booleanExpression();
        return (Boolean)new WorkflowConditionBooleanInterpreter().visit(tree);
    }
}

