/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.waveform.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.waveform.api.WaveformService;
import org.opencastproject.waveform.api.WaveformServiceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WaveformService.class}, property={"service.description=Waveform Remote Service Proxy"})
public class WaveformServiceRemote
extends RemoteBase
implements WaveformService {
    private static final Logger logger = LoggerFactory.getLogger(WaveformServiceRemote.class);

    public WaveformServiceRemote() {
        super("org.opencastproject.waveform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job createWaveformImage(Track sourceTrack, int pixelsPerMinute, int minWidth, int maxWidth, int height, String color) throws MediaPackageException, WaveformServiceException {
        HttpPost post = new HttpPost("/create");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("track", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("pixelsPerMinute", Integer.toString(pixelsPerMinute)));
            params.add(new BasicNameValuePair("minWidth", Integer.toString(minWidth)));
            params.add(new BasicNameValuePair("maxWidth", Integer.toString(maxWidth)));
            params.add(new BasicNameValuePair("height", Integer.toString(height)));
            params.add(new BasicNameValuePair("color", color));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new WaveformServiceException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Create waveform image from {}", (Object)sourceTrack);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new WaveformServiceException("Unable to create waveform image from " + String.valueOf(sourceTrack) + " using a remote service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new WaveformServiceException("Unable to create waveform image from " + String.valueOf(sourceTrack) + " using a remote service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

