/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.videosegmenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.videosegmenter.api.VideoSegmenterService;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Videosegmentation Workflow Operation Handler", "workflow.operation=segment-video"})
public class VideoSegmenterWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(VideoSegmenterWorkflowOperationHandler.class);
    private static final String PROP_ANALYSIS_TRACK_FLAVOR = "source-flavor";
    private static final String PROP_TARGET_TAGS = "target-tags";
    private static final String PROP_ANALYSIS_TRACK_TAG = "source-tags";
    private static final int MIN_VIDEO_LENGTH = 30000;
    private VideoSegmenterService videosegmenter = null;
    private Workspace workspace = null;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Track track;
        logger.debug("Running video segmentation on workflow {}", (Object)workflowInstance.getId());
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        String trackTag = StringUtils.trimToNull((String)operation.getConfiguration(PROP_ANALYSIS_TRACK_TAG));
        String trackFlavor = StringUtils.trimToNull((String)operation.getConfiguration(PROP_ANALYSIS_TRACK_FLAVOR));
        List targetTags = this.asList(operation.getConfiguration(PROP_TARGET_TAGS));
        ArrayList<Track> candidates = new ArrayList<Track>();
        if (StringUtils.isBlank((CharSequence)trackTag) && StringUtils.isBlank((CharSequence)trackFlavor)) {
            candidates.addAll(Arrays.asList(mediaPackage.getTracks(MediaPackageElements.PRESENTATION_SOURCE)));
        } else {
            TrackSelector elementSelector = new TrackSelector();
            if (StringUtils.isNotBlank((CharSequence)trackTag)) {
                elementSelector.addTag(trackTag);
            }
            if (StringUtils.isNotBlank((CharSequence)trackFlavor)) {
                elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)trackFlavor));
            }
            candidates.addAll(elementSelector.select(mediaPackage, true));
        }
        candidates.removeIf(t -> !t.hasVideo());
        if (candidates.size() == 0) {
            logger.info("No matching tracks available for video segmentation in workflow {}", (Object)workflowInstance);
            return this.createResult(WorkflowOperationResult.Action.CONTINUE);
        }
        if (candidates.size() > 1) {
            logger.info("Found more than one track to segment, choosing the first one ({})", candidates.get(0));
        }
        if ((track = (Track)candidates.get(0)).getDuration() != null && track.getDuration() < 30000L) {
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        Catalog mpeg7Catalog = null;
        Job job = null;
        try {
            job = this.videosegmenter.segment(track);
            if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
                throw new WorkflowOperationException("Video segmentation of " + String.valueOf(track) + " failed");
            }
            mpeg7Catalog = (Catalog)MediaPackageElementParser.getFromXml((String)job.getPayload());
            mediaPackage.add(mpeg7Catalog);
            mpeg7Catalog.setURI(this.workspace.moveTo(mpeg7Catalog.getURI(), mediaPackage.getIdentifier().toString(), mpeg7Catalog.getIdentifier(), "segments.xml"));
            mpeg7Catalog.setReference((MediaPackageReference)new MediaPackageReferenceImpl((MediaPackageElement)track));
            for (String tag : targetTags) {
                mpeg7Catalog.addTag(tag);
            }
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        logger.debug("Video segmentation completed");
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, job.getQueueTime());
    }

    @Reference
    protected void setVideoSegmenter(VideoSegmenterService videosegmenter) {
        this.videosegmenter = videosegmenter;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

