/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videosegmenter.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.videosegmenter.api.VideoSegmenterException;
import org.opencastproject.videosegmenter.api.VideoSegmenterService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoSegmenterService.class}, property={"service.description=VideoSegmenter Remote Service Proxy"})
public class VideoSegmenterRemoteImpl
extends RemoteBase
implements VideoSegmenterService {
    private static final Logger logger = LoggerFactory.getLogger(VideoSegmenterRemoteImpl.class);

    public VideoSegmenterRemoteImpl() {
        super("org.opencastproject.videosegmenter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job segment(Track track) throws VideoSegmenterException {
        HttpPost post = new HttpPost();
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("track", MediaPackageElementParser.getAsXml((MediaPackageElement)track)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new VideoSegmenterException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Analyzing {} on a remote analysis server", (Object)track);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new VideoSegmenterException("Unable to analyze element '" + track + "' using a remote analysis service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new VideoSegmenterException("Unable to analyze element '" + track + "' using a remote analysis service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

