/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videosegmenter.ffmpeg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.mpeg7.MediaLocator;
import org.opencastproject.metadata.mpeg7.MediaLocatorImpl;
import org.opencastproject.metadata.mpeg7.MediaRelTimeImpl;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimePointImpl;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogService;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.Video;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.videosegmenter.api.VideoSegmenterException;
import org.opencastproject.videosegmenter.api.VideoSegmenterService;
import org.opencastproject.videosegmenter.ffmpeg.OptimizationStep;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoSegmenterService.class, ManagedService.class}, property={"service.description=VideoSegmenter Service"})
public class VideoSegmenterServiceImpl
extends AbstractJobProducer
implements VideoSegmenterService,
ManagedService {
    public static final String COLLECTION_ID = "videosegments";
    protected String binary = "ffmpeg";
    public static final String FFMPEG_BINARY_CONFIG = "org.opencastproject.composer.ffmpeg.path";
    public static final String FFMPEG_BINARY_DEFAULT = "ffmpeg";
    public static final String OPT_STABILITY_THRESHOLD = "stabilitythreshold";
    public static final int DEFAULT_STABILITY_THRESHOLD = 60;
    public static final String OPT_CHANGES_THRESHOLD = "changesthreshold";
    public static final float DEFAULT_CHANGES_THRESHOLD = 0.025f;
    public static final String OPT_PREF_NUMBER = "prefNumber";
    public static final int DEFAULT_PREF_NUMBER = 30;
    public static final String OPT_MAX_CYCLES = "maxCycles";
    public static final int DEFAULT_MAX_CYCLES = 3;
    public static final String OPT_MAX_ERROR = "maxError";
    public static final float DEFAULT_MAX_ERROR = 0.25f;
    public static final String OPT_ABSOLUTE_MAX = "absoluteMax";
    public static final int DEFAULT_ABSOLUTE_MAX = 150;
    public static final String OPT_ABSOLUTE_MIN = "absoluteMin";
    public static final int DEFAULT_ABSOLUTE_MIN = 3;
    public static final String OPT_DURATION_DEPENDENT = "durationDependent";
    public static final boolean DEFAULT_DURATION_DEPENDENT = false;
    public static final String OPT_USE_CHAPTER_IF_AVAILABLE = "useChapterIfAvailable";
    public static final boolean DEFAULT_USE_CHAPTER_IF_AVAILABLE = false;
    private boolean useChapterIfAvailable = false;
    public static final String OPT_USE_CHAPTER_MIME_TYPES = "useChapterMimeTypes";
    public static final List<MimeType> DEFAULT_USE_CHAPTER_MIME_TYPES = new ArrayList<MimeType>();
    private List<MimeType> useChapterMimeTypes = DEFAULT_USE_CHAPTER_MIME_TYPES;
    public static final float DEFAULT_SEGMENTER_JOB_LOAD = 0.3f;
    public static final String SEGMENTER_JOB_LOAD_KEY = "job.load.videosegmenter";
    private float segmenterJobLoad = 0.3f;
    protected static final Logger logger = LoggerFactory.getLogger(VideoSegmenterServiceImpl.class);
    protected float changesThreshold = 0.025f;
    protected int stabilityThreshold = 60;
    protected int stabilityThresholdPrefilter = 1;
    protected int prefNumber = 30;
    protected int maxCycles = 3;
    protected float maxError = 0.25f;
    protected int absoluteMax = 150;
    protected int absoluteMin = 3;
    protected boolean durationDependent = false;
    protected ServiceRegistry serviceRegistry = null;
    protected Mpeg7CatalogService mpeg7CatalogService = null;
    protected Workspace workspace = null;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;

    public VideoSegmenterServiceImpl() {
        super("org.opencastproject.videosegmenter");
    }

    public void activate(ComponentContext cc) {
        super.activate(cc);
        String path = cc.getBundleContext().getProperty(FFMPEG_BINARY_CONFIG);
        this.binary = path == null ? FFMPEG_BINARY_DEFAULT : path;
        logger.debug("Configuration {}: {}", (Object)FFMPEG_BINARY_CONFIG, (Object)FFMPEG_BINARY_DEFAULT);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String value;
        String number;
        String threshold;
        if (properties == null) {
            return;
        }
        logger.debug("Configuring the videosegmenter");
        if (properties.get(OPT_STABILITY_THRESHOLD) != null) {
            threshold = (String)properties.get(OPT_STABILITY_THRESHOLD);
            try {
                this.stabilityThreshold = Integer.parseInt(threshold);
                logger.info("Stability threshold set to {} consecutive frames", (Object)this.stabilityThreshold);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_STABILITY_THRESHOLD, String.format("Found illegal value '%s'", threshold));
            }
        }
        if (properties.get(OPT_CHANGES_THRESHOLD) != null) {
            threshold = (String)properties.get(OPT_CHANGES_THRESHOLD);
            try {
                this.changesThreshold = Float.parseFloat(threshold);
                logger.info("Changes threshold set to {}", (Object)Float.valueOf(this.changesThreshold));
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_CHANGES_THRESHOLD, String.format("Found illegal value '%s'", threshold));
            }
        }
        if (properties.get(OPT_PREF_NUMBER) != null) {
            number = (String)properties.get(OPT_PREF_NUMBER);
            try {
                this.prefNumber = Integer.parseInt(number);
                logger.info("Preferred number of segments set to {}", (Object)this.prefNumber);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_PREF_NUMBER, String.format("Found illegal value '%s'", number));
            }
        }
        if (properties.get(OPT_MAX_CYCLES) != null) {
            number = (String)properties.get(OPT_MAX_CYCLES);
            try {
                this.maxCycles = Integer.parseInt(number);
                logger.info("Maximum number of cycles set to {}", (Object)this.maxCycles);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_MAX_CYCLES, String.format("Found illegal value '%s'", number));
            }
        }
        if (properties.get(OPT_ABSOLUTE_MAX) != null) {
            number = (String)properties.get(OPT_ABSOLUTE_MAX);
            try {
                this.absoluteMax = Integer.parseInt(number);
                logger.info("Absolute maximum number of segments set to {}", (Object)this.absoluteMax);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_ABSOLUTE_MAX, String.format("Found illegal value '%s'", number));
            }
        }
        if (properties.get(OPT_ABSOLUTE_MIN) != null) {
            number = (String)properties.get(OPT_ABSOLUTE_MIN);
            try {
                this.absoluteMin = Integer.parseInt(number);
                logger.info("Absolute minimum number of segments set to {}", (Object)this.absoluteMin);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_ABSOLUTE_MIN, String.format("Found illegal value '%s'", number));
            }
        }
        if (properties.get(OPT_DURATION_DEPENDENT) != null) {
            value = (String)properties.get(OPT_DURATION_DEPENDENT);
            try {
                this.durationDependent = BooleanUtils.toBooleanObject((String)StringUtils.trimToNull((String)value));
                logger.info("Dependency on video duration is set to {}", (Object)this.durationDependent);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_DURATION_DEPENDENT, String.format("Found illegal value '%s'", value));
            }
        }
        if (properties.get(OPT_USE_CHAPTER_IF_AVAILABLE) != null) {
            value = (String)properties.get(OPT_USE_CHAPTER_IF_AVAILABLE);
            try {
                this.useChapterIfAvailable = BooleanUtils.toBooleanObject((String)StringUtils.trimToNull((String)value));
                logger.info("Use Chapters if available is set to {}", (Object)this.useChapterIfAvailable);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_USE_CHAPTER_IF_AVAILABLE, String.format("Found illegal value '%s'", value));
            }
        }
        if (properties.get(OPT_USE_CHAPTER_MIME_TYPES) != null) {
            value = (String)properties.get(OPT_USE_CHAPTER_MIME_TYPES);
            try {
                String[] values;
                ArrayList<MimeType> mts = new ArrayList<MimeType>();
                for (String mimeString : values = value.split(",")) {
                    MimeType mt = MimeTypes.parseMimeType((String)mimeString);
                    mts.add(mt);
                }
                this.useChapterMimeTypes = mts;
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_USE_CHAPTER_MIME_TYPES, String.format("Found illegal value '%s'", value));
            }
        } else {
            this.useChapterMimeTypes = DEFAULT_USE_CHAPTER_MIME_TYPES;
        }
        this.segmenterJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)SEGMENTER_JOB_LOAD_KEY, (Float)Float.valueOf(0.3f), (ServiceRegistry)this.serviceRegistry);
    }

    public Job segment(Track track) throws VideoSegmenterException, MediaPackageException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.videosegmenter", Operation.Segment.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)track)), Float.valueOf(this.segmenterJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new VideoSegmenterException("Unable to create a job", (Throwable)e);
        }
    }

    protected Catalog segment(Job job, Track track) throws VideoSegmenterException, MediaPackageException {
        if (!track.hasVideo()) {
            logger.warn("Element {} is not a video track", (Object)track);
            throw new VideoSegmenterException("Element is not a video track");
        }
        try {
            URI uri;
            File mediaFile = null;
            URL mediaUrl = null;
            try {
                mediaFile = this.workspace.get(track.getURI());
                mediaUrl = mediaFile.toURI().toURL();
            }
            catch (NotFoundException e) {
                throw new VideoSegmenterException("Error finding the video file in the workspace", (Throwable)e);
            }
            catch (IOException e) {
                throw new VideoSegmenterException("Error reading the video file in the workspace", (Throwable)e);
            }
            if (track.getDuration() == null) {
                throw new MediaPackageException("Track " + String.valueOf(track) + " does not have a duration");
            }
            logger.info("Track {} loaded, duration is {} s", (Object)mediaUrl, (Object)(track.getDuration() / 1000L));
            Optional<Object> chapter = Optional.empty();
            if (this.useChapterIfAvailable && (this.useChapterMimeTypes.isEmpty() || this.useChapterMimeTypes.stream().anyMatch(comp -> track.getMimeType().eq(comp)))) {
                chapter = Optional.ofNullable(this.extractChapter(mediaFile));
            }
            Mpeg7Catalog mpeg7 = chapter.isPresent() && !((List)chapter.get()).isEmpty() ? this.segmentFromChapter((List)chapter.get(), track) : this.segmentAndOptimize(track, mediaFile, mediaUrl);
            Catalog mpeg7Catalog = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(Catalog.TYPE, MediaPackageElements.SEGMENTS);
            try {
                uri = this.workspace.putInCollection(COLLECTION_ID, job.getId() + ".xml", this.mpeg7CatalogService.serialize(mpeg7));
            }
            catch (IOException e) {
                throw new VideoSegmenterException("Unable to put the mpeg7 catalog into the workspace", (Throwable)e);
            }
            mpeg7Catalog.setURI(uri);
            logger.info("Finished video segmentation of {}", (Object)mediaUrl);
            return mpeg7Catalog;
        }
        catch (Exception e) {
            logger.warn("Error segmenting " + String.valueOf(track), (Throwable)e);
            if (e instanceof VideoSegmenterException) {
                throw (VideoSegmenterException)e;
            }
            throw new VideoSegmenterException((Throwable)e);
        }
    }

    private List<Chapter> extractChapter(File mediaFile) throws IOException {
        block8: {
            List<Chapter> list;
            String[] command = new String[]{this.binary, "-nostats", "-nostdin", "-i", mediaFile.getAbsolutePath(), "-f", "FFMETADATA", "-"};
            logger.debug("Detecting chapters using command: {}", (Object)command);
            ProcessBuilder pbuilder = new ProcessBuilder(command);
            Process process = pbuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                list = this.parseChapter(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error executing ffmpeg: {}", (Object)e.getMessage());
                    break block8;
                }
                catch (ParseException e) {
                    logger.error("Error parsing ffmpeg output: {}", (Object)e.getMessage());
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    private List<Chapter> parseChapter(BufferedReader reader) throws IOException, ParseException {
        ArrayList<Chapter> chapters;
        block36: {
            chapters = new ArrayList<Chapter>();
            int state = 0;
            double defaultTimebase = 1.0E-9f;
            double timebase = 1.0E-9f;
            long start = -1L;
            long end = -1L;
            Optional<Object> title = Optional.empty();
            String line = reader.readLine();
            int lineNumber = 1;
            if (line == null) {
                return chapters;
            }
            while (true) {
                if (state == 0 && ";FFMETADATA1".equals(line)) {
                    ++state;
                } else if (line == null || !line.startsWith(";") && !line.startsWith("#") && !line.isEmpty()) {
                    if (state == 1 && "[CHAPTER]".equals(line)) {
                        ++state;
                    } else if (state == 2) {
                        if (!line.startsWith("TIMEBASE=")) {
                            ++state;
                            continue;
                        }
                        String[] timebaseSplit = line.split("=");
                        if (timebaseSplit.length != 2) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER TIMEBASE line not correctly formatted", lineNumber);
                        }
                        String ratio = timebaseSplit[1];
                        String[] numbers = ratio.split("/");
                        if (numbers.length != 2) {
                            throw new ParseException("Failed to parse FFMETADATA: ratio not correctly formatted", lineNumber);
                        }
                        try {
                            timebase = Double.parseDouble(numbers[0]) / Double.parseDouble(numbers[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Failed to parse FFMETADATA: Couldn't parse timebase as ratio of integer numbers", lineNumber);
                        }
                        ++state;
                    } else if (state == 3) {
                        if (!line.startsWith("START=")) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER START field missing", lineNumber);
                        }
                        String[] startSplit = line.split("=");
                        if (startSplit.length != 2) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER START line not correctly formatted", lineNumber);
                        }
                        try {
                            start = Long.parseLong(startSplit[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER START needs to be an Integer", lineNumber);
                        }
                        ++state;
                    } else if (state == 4) {
                        if (!line.startsWith("END=")) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER END field missing", lineNumber);
                        }
                        String[] endSplit = line.split("=");
                        if (endSplit.length != 2) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER END line not correctly formatted", lineNumber);
                        }
                        try {
                            end = Long.parseLong(endSplit[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Failed to parse FFMETADATA: CHAPTER START needs to be an Integer", lineNumber);
                        }
                        ++state;
                    } else {
                        if (state == 5) {
                            if (!line.startsWith("title=")) {
                                state = 7;
                                continue;
                            }
                            String fakeLine = Arrays.stream(line.split("=")).skip(1L).collect(Collectors.joining());
                            title = Optional.of(new StringBuilder());
                            line = fakeLine;
                            ++state;
                            continue;
                        }
                        if (state == 6) {
                            int[] codePoints = line.codePoints().toArray();
                            boolean isEscaped = false;
                            for (int codePoint : codePoints) {
                                if (isEscaped) {
                                    ((StringBuilder)title.get()).appendCodePoint(codePoint);
                                    isEscaped = false;
                                    continue;
                                }
                                if (codePoint == "\\".codePointAt(0)) {
                                    isEscaped = true;
                                    continue;
                                }
                                if (codePoint == "=".codePointAt(0) || codePoint == ";".codePointAt(0) || codePoint == "#".codePointAt(0)) {
                                    throw new ParseException("Failed to parse FFMETADATA: CHAPTER title field '=' ';' '#' '\\' '\\n' have to be escaped", lineNumber);
                                }
                                ((StringBuilder)title.get()).appendCodePoint(codePoint);
                            }
                            if (!isEscaped) {
                                ++state;
                            }
                        } else if (state == 7) {
                            state = 1;
                            Chapter chapter = new Chapter(this);
                            chapter.title = title.map(t -> t.toString());
                            chapter.start = timebase * (double)start;
                            chapter.end = timebase * (double)end;
                            chapters.add(chapter);
                            timebase = 1.0E-9f;
                            start = -1L;
                            end = -1L;
                            title = Optional.empty();
                            if (line != null) continue;
                            break block36;
                        }
                    }
                }
                line = reader.readLine();
                ++lineNumber;
                if (line != null) continue;
                if (state <= 1) break block36;
                if (state != 5 && state != 7) break;
                state = 7;
            }
            throw new ParseException("Failed to parse FFMETADATA: Unexpected end of file", lineNumber);
        }
        return chapters;
    }

    private Mpeg7Catalog segmentFromChapter(List<Chapter> chapters, Track track) {
        Mpeg7Catalog mpeg7 = this.mpeg7CatalogService.newInstance();
        MediaRelTimeImpl contentTime = new MediaRelTimeImpl(0L, track.getDuration().longValue());
        MediaLocatorImpl contentLocator = new MediaLocatorImpl(track.getURI());
        Video videoContent = mpeg7.addVideoContent("videosegment", (MediaTime)contentTime, (MediaLocator)contentLocator);
        int segmentNum = 0;
        for (Chapter chapter : chapters) {
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + ++segmentNum);
            s.setMediaTime((MediaTime)new MediaRelTimeImpl((long)(chapter.start * 1000.0), (long)(chapter.end * 1000.0)));
        }
        return mpeg7;
    }

    private Mpeg7Catalog segmentAndOptimize(Track track, File mediaFile, URL mediaUrl) throws IOException, VideoSegmenterException {
        LinkedList<Segment> tmpSegments;
        int i;
        LinkedList<Segment> segments;
        Mpeg7Catalog mpeg7 = null;
        MediaRelTimeImpl contentTime = new MediaRelTimeImpl(0L, track.getDuration().longValue());
        MediaLocatorImpl contentLocator = new MediaLocatorImpl(track.getURI());
        logger.debug("changesThreshold: {}, stabilityThreshold: {}", (Object)Float.valueOf(this.changesThreshold), (Object)this.stabilityThreshold);
        logger.debug("prefNumber: {}, maxCycles: {}", (Object)this.prefNumber, (Object)this.maxCycles);
        boolean endOptimization = false;
        int cycleCount = 0;
        LinkedList<OptimizationStep> optimizationList = new LinkedList<OptimizationStep>();
        LinkedList<OptimizationStep> unusedResultsList = new LinkedList<OptimizationStep>();
        OptimizationStep stepBest = new OptimizationStep();
        float changesThresholdLocal = this.changesThreshold;
        int prefNumberLocal = this.prefNumber;
        int absoluteMaxLocal = this.absoluteMax;
        int absoluteMinLocal = this.absoluteMin;
        if (this.durationDependent) {
            double trackDurationInHours = (double)track.getDuration().longValue() / 3600000.0;
            prefNumberLocal = (int)Math.round(trackDurationInHours * (double)prefNumberLocal);
            absoluteMaxLocal = (int)Math.round(trackDurationInHours * (double)this.absoluteMax);
            absoluteMinLocal = (int)Math.round(trackDurationInHours * (double)this.absoluteMin);
            if (prefNumberLocal <= 0) {
                prefNumberLocal = 1;
            }
            logger.info("Numbers of segments are set to be relative to track duration. Therefore for {} the preferred number of segments is {}", (Object)mediaUrl, (Object)prefNumberLocal);
        }
        logger.info("Starting video segmentation of {}", (Object)mediaUrl);
        while (!endOptimization) {
            OptimizationStep currentStepBest;
            mpeg7 = this.mpeg7CatalogService.newInstance();
            Video videoContent = mpeg7.addVideoContent("videosegment", (MediaTime)contentTime, (MediaLocator)contentLocator);
            segments = this.runSegmentationFFmpeg(track, videoContent, mediaFile, changesThresholdLocal);
            OptimizationStep currentStep = new OptimizationStep(changesThresholdLocal, segments.size(), prefNumberLocal, mpeg7, segments);
            LinkedList<Segment> segmentsNew = new LinkedList<Segment>();
            OptimizationStep currentStepFiltered = new OptimizationStep(changesThresholdLocal, 0, prefNumberLocal, this.filterSegmentation(segments, track, segmentsNew, this.stabilityThreshold * 1000), segments);
            currentStepFiltered.setSegmentNumAndRecalcErrors(segmentsNew.size());
            logger.info("Segmentation yields {} segments after filtering", (Object)segmentsNew.size());
            if (currentStep.getErrorAbs() <= currentStepFiltered.getErrorAbs() || segmentsNew.size() < prefNumberLocal && (float)currentStep.getSegmentNum() > (float)track.getDuration().longValue() / 1000.0f / (float)(this.stabilityThreshold / 2) && !(currentStepFiltered.getErrorAbs() <= this.maxError)) {
                optimizationList.add(currentStep);
                Collections.sort(optimizationList);
                currentStepBest = currentStep;
                unusedResultsList.add(currentStepFiltered);
            } else {
                optimizationList.add(currentStepFiltered);
                Collections.sort(optimizationList);
                currentStepBest = currentStepFiltered;
            }
            logger.debug("errorAbs = {}, error = {}", (Object)Float.valueOf(currentStep.getErrorAbs()), (Object)Float.valueOf(currentStep.getError()));
            logger.debug("changesThreshold = {}", (Object)Float.valueOf(changesThresholdLocal));
            logger.debug("cycleCount = {}", (Object)(++cycleCount));
            if (cycleCount >= this.maxCycles || currentStepBest.getErrorAbs() <= this.maxError) {
                endOptimization = true;
                if (optimizationList.size() > 0) {
                    stepBest = ((OptimizationStep)optimizationList.getFirst()).getErrorAbs() <= ((OptimizationStep)optimizationList.getLast()).getErrorAbs() && ((OptimizationStep)optimizationList.getFirst()).getError() >= 0.0f ? (OptimizationStep)optimizationList.getFirst() : (OptimizationStep)optimizationList.getLast();
                }
                for (OptimizationStep currentUnusedStep : unusedResultsList) {
                    if (!(currentUnusedStep.getErrorAbs() < stepBest.getErrorAbs())) continue;
                    stepBest = (OptimizationStep)unusedResultsList.getFirst();
                }
                continue;
            }
            OptimizationStep first = (OptimizationStep)optimizationList.getFirst();
            OptimizationStep last = (OptimizationStep)optimizationList.getLast();
            if (optimizationList.size() == 1 || first.getError() < 0.0f || last.getError() > 0.0f) {
                changesThresholdLocal = currentStepBest.getError() >= 0.0f ? (currentStepBest.getError() <= 1.0f ? (changesThresholdLocal += changesThresholdLocal * currentStepBest.getError()) : (cycleCount <= 1 && currentStep.getSegmentNum() > 2000 ? 0.2f : (changesThresholdLocal *= 2.0f))) : (changesThresholdLocal /= 2.0f);
                logger.debug("onesided optimization yields new changesThreshold = {}", (Object)Float.valueOf(changesThresholdLocal));
                continue;
            }
            float x = (float)(first.getSegmentNum() - prefNumberLocal) / (float)(first.getSegmentNum() - last.getSegmentNum());
            float newX = (x + 0.5f) * 0.5f;
            changesThresholdLocal = first.getChangesThreshold() * (1.0f - newX) + last.getChangesThreshold() * newX;
            logger.debug("doublesided optimization yields new changesThreshold = {}", (Object)Float.valueOf(changesThresholdLocal));
        }
        int threshLow = this.stabilityThreshold * 1000;
        int threshHigh = threshLow + threshLow / 2;
        float smallestError = Float.MAX_VALUE;
        int bestI = threshLow;
        segments = stepBest.getSegments();
        if (stepBest.getError() <= this.maxError) {
            threshHigh = this.stabilityThreshold * 1000;
        }
        for (i = threshLow; i <= threshHigh; i += 1000) {
            tmpSegments = new LinkedList<Segment>();
            this.filterSegmentation(segments, track, tmpSegments, i);
            float newError = OptimizationStep.calculateErrorAbs(tmpSegments.size(), prefNumberLocal);
            if (!(newError < smallestError)) continue;
            smallestError = newError;
            bestI = i;
        }
        tmpSegments = new LinkedList();
        mpeg7 = this.filterSegmentation(segments, track, tmpSegments, bestI);
        logger.debug("result segments:");
        for (i = 0; i < tmpSegments.size(); ++i) {
            int[] tmpLog2 = new int[7];
            tmpLog2[0] = tmpSegments.get(i).getMediaTime().getMediaTimePoint().getHour();
            tmpLog2[1] = tmpSegments.get(i).getMediaTime().getMediaTimePoint().getMinutes();
            tmpLog2[2] = tmpSegments.get(i).getMediaTime().getMediaTimePoint().getSeconds();
            tmpLog2[3] = tmpSegments.get(i).getMediaTime().getMediaDuration().getHours();
            tmpLog2[4] = tmpSegments.get(i).getMediaTime().getMediaDuration().getMinutes();
            tmpLog2[5] = tmpSegments.get(i).getMediaTime().getMediaDuration().getSeconds();
            Object[] tmpLog1 = new Object[]{tmpLog2[0], tmpLog2[1], tmpLog2[2], tmpLog2[3], tmpLog2[4], tmpLog2[5], tmpLog2[6]};
            tmpLog1[6] = tmpSegments.get(i).getIdentifier();
            logger.debug("s:{}:{}:{}, d:{}:{}:{}, {}", tmpLog1);
        }
        logger.info("Optimized Segmentation yields (after {} iteration" + (cycleCount == 1 ? "" : "s") + ") {} segments", (Object)cycleCount, (Object)tmpSegments.size());
        if (tmpSegments.size() < absoluteMinLocal || tmpSegments.size() > absoluteMaxLocal) {
            mpeg7 = this.uniformSegmentation(track, tmpSegments, prefNumberLocal);
            logger.info("Since no reasonable segmentation could be found, a uniform segmentation was created");
        }
        return mpeg7;
    }

    private LinkedList<Segment> runSegmentationFFmpeg(Track track, Video videoContent, File mediaFile, float changesThreshold) throws IOException, VideoSegmenterException {
        String[] command = new String[]{this.binary, "-nostats", "-nostdin", "-i", mediaFile.getAbsolutePath(), "-filter:v", "select=gt(scene\\," + changesThreshold + "),showinfo", "-f", "null", "-"};
        logger.info("Detecting video segments using command: {}", (Object)command);
        ProcessBuilder pbuilder = new ProcessBuilder(command);
        LinkedList<String> segmentsStrings = new LinkedList<String>();
        Process process = pbuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line = reader.readLine();
            while (null != line) {
                if (line.startsWith("[Parsed_showinfo")) {
                    segmentsStrings.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            logger.error("Error executing ffmpeg: {}", (Object)e.getMessage());
        }
        int segmentcount = 1;
        LinkedList<Segment> segments = new LinkedList<Segment>();
        if (segmentsStrings.size() == 0) {
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount);
            s.setMediaTime((MediaTime)new MediaRelTimeImpl(0L, track.getDuration().longValue()));
            segments.add(s);
        } else {
            long starttime = 0L;
            long endtime = 0L;
            Pattern pattern = Pattern.compile("pts_time\\:\\d+(\\.\\d+)?");
            for (String seginfo : segmentsStrings) {
                Matcher matcher = pattern.matcher(seginfo);
                String time = "";
                while (matcher.find()) {
                    time = matcher.group().substring(9);
                }
                if ("".equals(time)) continue;
                try {
                    endtime = Math.round(Float.parseFloat(time) * 1000.0f);
                }
                catch (NumberFormatException e) {
                    logger.error("Unable to parse FFmpeg output, likely FFmpeg version mismatch!", (Throwable)e);
                    throw new VideoSegmenterException((Throwable)e);
                }
                long segmentLength = endtime - starttime;
                if ((long)(1000 * this.stabilityThresholdPrefilter) >= segmentLength) continue;
                Segment segment = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount);
                segment.setMediaTime((MediaTime)new MediaRelTimeImpl(starttime, endtime - starttime));
                logger.debug("Created segment {} at start time {} with duration {}", new Object[]{segmentcount, starttime, endtime});
                segments.add(segment);
                ++segmentcount;
                starttime = endtime;
            }
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount);
            s.setMediaTime((MediaTime)new MediaRelTimeImpl(starttime, track.getDuration() - starttime));
            logger.debug("Created segment {} at start time {} with duration {}", new Object[]{segmentcount, starttime, track.getDuration() - endtime});
            segments.add(s);
        }
        logger.info("Segmentation of {} yields {} segments", (Object)mediaFile.toURI().toURL(), (Object)segments.size());
        return segments;
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            switch (op.ordinal()) {
                case 0: {
                    Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    Catalog catalog = this.segment(job, track);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)catalog);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + String.valueOf((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
    }

    protected Mpeg7Catalog filterSegmentation(LinkedList<Segment> segments, Track track, LinkedList<Segment> segmentsNew) {
        int mergeThresh = this.stabilityThreshold * 1000;
        return this.filterSegmentation(segments, track, segmentsNew, mergeThresh);
    }

    protected Mpeg7Catalog filterSegmentation(LinkedList<Segment> segments, Track track, LinkedList<Segment> segmentsNew, int mergeThresh) {
        if (segmentsNew == null) {
            segmentsNew = new LinkedList();
        }
        boolean merging = false;
        MediaRelTimeImpl contentTime = new MediaRelTimeImpl(0L, track.getDuration().longValue());
        MediaLocatorImpl contentLocator = new MediaLocatorImpl(track.getURI());
        Mpeg7Catalog mpeg7 = this.mpeg7CatalogService.newInstance();
        Video videoContent = mpeg7.addVideoContent("videosegment", (MediaTime)contentTime, (MediaLocator)contentLocator);
        int segmentcount = 1;
        MediaTimePointImpl currentSegStart = new MediaTimePointImpl();
        for (Segment o : segments) {
            if (o.getMediaTime().getMediaDuration().getDurationInMilliseconds() <= (long)mergeThresh) {
                if (merging) continue;
                currentSegStart = o.getMediaTime().getMediaTimePoint();
                merging = true;
                continue;
            }
            long currentSegDuration = o.getMediaTime().getMediaDuration().getDurationInMilliseconds();
            long currentSegEnd = o.getMediaTime().getMediaTimePoint().getTimeInMilliseconds() + currentSegDuration;
            if (merging) {
                long newDuration = o.getMediaTime().getMediaTimePoint().getTimeInMilliseconds() - currentSegStart.getTimeInMilliseconds();
                if (newDuration >= (long)mergeThresh) {
                    Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount++);
                    s.setMediaTime((MediaTime)new MediaRelTimeImpl(currentSegStart.getTimeInMilliseconds(), newDuration));
                    segmentsNew.add(s);
                    Segment s2 = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount++);
                    s2.setMediaTime(o.getMediaTime());
                    segmentsNew.add(s2);
                } else {
                    long followingStartOld = o.getMediaTime().getMediaTimePoint().getTimeInMilliseconds();
                    long newSplit = (currentSegStart.getTimeInMilliseconds() + followingStartOld) / 2L;
                    long followingEnd = followingStartOld + o.getMediaTime().getMediaDuration().getDurationInMilliseconds();
                    long followingDuration = followingEnd - newSplit;
                    if (segmentsNew.isEmpty()) {
                        Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount++);
                        s.setMediaTime((MediaTime)new MediaRelTimeImpl(0L, followingEnd));
                        segmentsNew.add(s);
                    } else {
                        long previousStart = ((Segment)segmentsNew.getLast()).getMediaTime().getMediaTimePoint().getTimeInMilliseconds();
                        ((Segment)segmentsNew.getLast()).setMediaTime((MediaTime)new MediaRelTimeImpl(previousStart, newSplit - previousStart));
                        Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount++);
                        s.setMediaTime((MediaTime)new MediaRelTimeImpl(newSplit, followingDuration));
                        segmentsNew.add(s);
                    }
                }
                merging = false;
                continue;
            }
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount++);
            s.setMediaTime(o.getMediaTime());
            segmentsNew.add(s);
        }
        if (merging && !segmentsNew.isEmpty()) {
            long newDuration = track.getDuration() - currentSegStart.getTimeInMilliseconds();
            if (newDuration >= (long)mergeThresh) {
                Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount);
                s.setMediaTime((MediaTime)new MediaRelTimeImpl(currentSegStart.getTimeInMilliseconds(), newDuration));
                segmentsNew.add(s);
            } else {
                newDuration = track.getDuration() - ((Segment)segmentsNew.getLast()).getMediaTime().getMediaTimePoint().getTimeInMilliseconds();
                ((Segment)segmentsNew.getLast()).setMediaTime((MediaTime)new MediaRelTimeImpl(((Segment)segmentsNew.getLast()).getMediaTime().getMediaTimePoint().getTimeInMilliseconds(), newDuration));
            }
        }
        if (segmentsNew.isEmpty()) {
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + segmentcount);
            s.setMediaTime((MediaTime)new MediaRelTimeImpl(0L, track.getDuration().longValue()));
            segmentsNew.add(s);
        }
        return mpeg7;
    }

    protected Mpeg7Catalog uniformSegmentation(Track track, LinkedList<Segment> segmentsNew, int prefNumber) {
        if (segmentsNew == null) {
            segmentsNew = new LinkedList();
        }
        MediaRelTimeImpl contentTime = new MediaRelTimeImpl(0L, track.getDuration().longValue());
        MediaLocatorImpl contentLocator = new MediaLocatorImpl(track.getURI());
        Mpeg7Catalog mpeg7 = this.mpeg7CatalogService.newInstance();
        Video videoContent = mpeg7.addVideoContent("videosegment", (MediaTime)contentTime, (MediaLocator)contentLocator);
        long segmentDuration = track.getDuration() / (long)prefNumber;
        long currentSegStart = 0L;
        for (int i = 1; i < prefNumber; ++i) {
            Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + i);
            s.setMediaTime((MediaTime)new MediaRelTimeImpl(currentSegStart, segmentDuration));
            segmentsNew.add(s);
            currentSegStart += segmentDuration;
        }
        Segment s = videoContent.getTemporalDecomposition().createSegment("segment-" + prefNumber);
        s.setMediaTime((MediaTime)new MediaRelTimeImpl(currentSegStart, track.getDuration() - currentSegStart));
        segmentsNew.add(s);
        return mpeg7;
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference(name="Mpeg7Service")
    protected void setMpeg7CatalogService(Mpeg7CatalogService mpeg7CatalogService) {
        this.mpeg7CatalogService = mpeg7CatalogService;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    private static enum Operation {
        Segment;

    }

    private class Chapter {
        protected double start;
        protected double end;
        protected Optional<String> title;

        private Chapter(VideoSegmenterServiceImpl videoSegmenterServiceImpl) {
        }
    }
}

