/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videoeditor.ffmpeg;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.util.IoSupport;
import org.opencastproject.videoeditor.impl.VideoClip;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegEdit {
    private static final Logger logger = LoggerFactory.getLogger(FFmpegEdit.class);
    private static final String FFMPEG_BINARY_DEFAULT = "ffmpeg";
    private static final String CONFIG_FFMPEG_PATH = "org.opencastproject.composer.ffmpeg.path";
    private static final String DEFAULT_FFMPEG_PROPERTIES = "-preset faster -crf 18";
    private static final String DEFAULT_AUDIO_FADE = "0.2";
    private static final String DEFAULT_VIDEO_FADE = "0.2";
    private static String binary = "ffmpeg";
    protected float vfade;
    protected float afade;
    protected String ffmpegProperties = "-preset faster -crf 18";
    protected String ffmpegScaleFilter = null;
    protected String videoCodec = null;
    protected String audioCodec = null;

    public static void init(BundleContext bundleContext) {
        String path = bundleContext.getProperty(CONFIG_FFMPEG_PATH);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            binary = path.trim();
        }
    }

    public FFmpegEdit() {
        this.afade = Float.parseFloat("0.2");
        this.vfade = Float.parseFloat("0.2");
        this.ffmpegProperties = DEFAULT_FFMPEG_PROPERTIES;
    }

    public FFmpegEdit(Properties properties) {
        String fade = properties.getProperty("audio.fade", "0.2");
        this.afade = Float.parseFloat(fade);
        fade = properties.getProperty("video.fade", "0.2");
        this.vfade = Float.parseFloat(fade);
        this.ffmpegProperties = properties.getProperty("ffmpeg.properties", DEFAULT_FFMPEG_PROPERTIES);
        this.ffmpegScaleFilter = properties.getProperty("ffmpeg.scalefilter", null);
        this.videoCodec = properties.getProperty("video.codec", null);
        this.audioCodec = properties.getProperty("audio.codec", null);
    }

    public String processEdits(List<String> inputfiles, String dest, String outputSize, List<VideoClip> cleanclips) throws Exception {
        return this.processEdits(inputfiles, dest, outputSize, cleanclips, true, true);
    }

    public String processEdits(List<String> inputfiles, String dest, String outputSize, List<VideoClip> cleanclips, boolean hasAudio, boolean hasVideo) throws Exception {
        List<String> cmd = this.makeEdits(inputfiles, dest, outputSize, cleanclips, hasAudio, hasVideo);
        return this.run(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String run(List<String> params) {
        BufferedReader in = null;
        Process encoderProcess = null;
        try {
            String line;
            params.add(0, "-nostats");
            params.add(0, "-nostdin");
            params.add(0, "-hide_banner");
            params.add(0, binary);
            logger.info("executing command: " + StringUtils.join(params, (String)" "));
            ProcessBuilder pbuilder = new ProcessBuilder(params);
            pbuilder.redirectErrorStream(true);
            encoderProcess = pbuilder.start();
            in = new BufferedReader(new InputStreamReader(encoderProcess.getInputStream()));
            int n = 5;
            while ((line = in.readLine()) != null) {
                if (n-- <= 0) continue;
                logger.info(line);
            }
            encoderProcess.waitFor();
            int exitCode = encoderProcess.exitValue();
            if (exitCode != 0) {
                throw new Exception("Ffmpeg exited abnormally with status " + exitCode);
            }
            IoSupport.closeQuietly((Closeable)in);
        }
        catch (Exception ex) {
            logger.error("VideoEditor ffmpeg failed", (Throwable)ex);
            String string = ex.toString();
            return string;
        }
        finally {
            IoSupport.closeQuietly(in);
            IoSupport.closeQuietly(encoderProcess);
        }
        IoSupport.closeQuietly((Process)encoderProcess);
        return null;
    }

    public List<String> makeEdits(List<String> inputfiles, String dest, String outputResolution, List<VideoClip> clips, boolean hasAudio, boolean hasVideo) throws Exception {
        int i;
        if (!hasAudio && !hasVideo) {
            throw new IllegalArgumentException("Inputfiles should have at least audio or video stream.");
        }
        DecimalFormat f = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        int n = clips.size();
        String outmap = "";
        Object scale = "";
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<CallSite> vpads = new ArrayList<CallSite>();
        ArrayList<CallSite> apads = new ArrayList<CallSite>();
        ArrayList<Object> clauses = new ArrayList<Object>();
        if (n > 1) {
            for (i = 0; i < n; ++i) {
                if (hasVideo) {
                    vpads.add((CallSite)((Object)("[v" + i + "]")));
                }
                if (!hasAudio) continue;
                apads.add((CallSite)((Object)("[a" + i + "]")));
            }
        }
        if (hasVideo) {
            if (outputResolution != null && outputResolution.length() > 3) {
                scale = ",scale=" + outputResolution;
            } else if (this.ffmpegScaleFilter != null) {
                scale = ",scale=" + this.ffmpegScaleFilter;
            }
        }
        for (i = 0; i < n; ++i) {
            VideoClip vclip = clips.get(i);
            int fileindx = vclip.getSrc();
            double inpt = vclip.getStartInSeconds();
            double duration = vclip.getDurationInSeconds();
            Object clip = "";
            if (hasVideo) {
                Object vfadeFilter = "";
                if ((double)this.vfade > 1.0E-5) {
                    double vend = duration - (double)this.vfade;
                    vfadeFilter = ",fade=t=in:st=0:d=" + this.vfade + ",fade=t=out:st=" + f.format(vend) + ":d=" + this.vfade;
                }
                clip = "[" + fileindx + ":v]trim=" + f.format(inpt) + ":duration=" + f.format(duration) + (String)scale + ",setpts=PTS-STARTPTS" + (String)vfadeFilter + "[v" + i + "]";
                clauses.add(clip);
            }
            if (!hasAudio) continue;
            Object afadeFilter = "";
            if ((double)this.afade > 1.0E-5) {
                double aend = duration - (double)this.afade;
                afadeFilter = ",afade=t=in:st=0:d=" + this.afade + ",afade=t=out:st=" + f.format(aend) + ":d=" + this.afade;
            }
            clip = "[" + fileindx + ":a]atrim=" + f.format(inpt) + ":duration=" + f.format(duration) + ",asetpts=PTS-STARTPTS" + (String)afadeFilter + "[a" + i + "]";
            clauses.add(clip);
        }
        if (n > 1) {
            if (hasVideo) {
                clauses.add(StringUtils.join(vpads, (String)"") + "concat=n=" + n + ":unsafe=1[ov0]");
            }
            if (hasAudio) {
                clauses.add(StringUtils.join(apads, (String)"") + "concat=n=" + n + ":v=0:a=1[oa0]");
            }
            outmap = "o";
        }
        for (String o : inputfiles) {
            command.add("-i");
            command.add(o);
        }
        command.add("-filter_complex");
        command.add(StringUtils.join(clauses, (String)";"));
        String[] options = this.ffmpegProperties.split(" ");
        command.addAll(Arrays.asList(options));
        if (hasAudio) {
            command.add("-map");
            command.add("[" + outmap + "a0]");
        }
        if (hasVideo) {
            command.add("-map");
            command.add("[" + outmap + "v0]");
        }
        if (hasVideo && this.videoCodec != null) {
            command.add("-c:v");
            command.add(this.videoCodec);
        }
        if (hasAudio && this.audioCodec != null) {
            command.add("-c:a");
            command.add(this.audioCodec);
        }
        command.add(dest);
        return command;
    }
}

