/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videoeditor.endpoint;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJobList;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.videoeditor.api.VideoEditorService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/videoeditor")
@RestService(name="VideoEditorServiceEndpoint", title="Video Editor Service REST Endpoint", abstractText="Video Editor Service consumes a smil document and create corresponding video files.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/videoeditor)"})
@Component(immediate=true, service={VideoEditorServiceEndpoint.class}, property={"service.description=Video Editor Service REST Endpoint", "opencast.service.type=org.opencastproject.videoeditor", "opencast.service.path=/videoeditor", "opencast.service.jobproducer=true"})
@JaxrsResource
public class VideoEditorServiceEndpoint
extends AbstractJobProducerEndpoint {
    private ServiceRegistry serviceRegistry;
    private VideoEditorService videoEditorService;
    private SmilService smilService;

    @POST
    @Path(value="/process-smil")
    @Produces(value={"application/xml"})
    @RestQuery(name="processsmil", description="Create smil processing jobs.", returnDescription="Smil processing jobs.", restParameters={@RestParameter(name="smil", type=RestParameter.Type.TEXT, description="Smil document to process.", isRequired=true)}, responses={@RestResponse(description="Smil processing jobs created successfully.", responseCode=200), @RestResponse(description="Internal server error.", responseCode=500)})
    public Response processSmil(@FormParam(value="smil") String smilStr) {
        try {
            Smil smil = this.smilService.fromXml(smilStr).getSmil();
            List jobs = this.videoEditorService.processSmil(smil);
            return Response.ok((Object)new JaxbJobList((Collection)jobs)).build();
        }
        catch (Exception ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
    }

    public JobProducer getService() {
        if (this.videoEditorService instanceof JobProducer) {
            return (JobProducer)this.videoEditorService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setVideoEditorService(VideoEditorService videoEditorService) {
        this.videoEditorService = videoEditorService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }
}

