/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.studip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.security.api.CachingUserProviderMXBean;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.studip.StudipUserProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudipUserProviderInstance
implements UserProvider,
RoleProvider,
CachingUserProviderMXBean {
    public static final String PROVIDER_NAME = "studip";
    private static final String OC_USERAGENT = "Opencast";
    private static final String STUDIP_GROUP = "ROLE_GROUP_STUDIP";
    private static final Logger logger = LoggerFactory.getLogger(StudipUserProviderInstance.class);
    private Organization organization = null;
    private AtomicLong requests = null;
    private AtomicLong studipLoads = null;
    private LoadingCache<String, Object> cache = null;
    protected Object nullToken = new Object();
    private URI studipUrl;
    private String studipToken = null;

    public StudipUserProviderInstance(String pid, Organization organization, URI url, String token, int cacheSize, int cacheExpiration) {
        this.organization = organization;
        this.studipUrl = url;
        this.studipToken = token;
        logger.info("Creating new StudipUserProviderInstance(pid={}, url={}, cacheSize={}, cacheExpiration={})", new Object[]{pid, url, cacheSize, cacheExpiration});
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)cacheExpiration, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String id) throws Exception {
                User user = StudipUserProviderInstance.this.loadUserFromStudip(id);
                return user == null ? StudipUserProviderInstance.this.nullToken : user;
            }
        });
        this.registerMBean(pid);
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    protected void registerMBean(String pid) {
        this.requests = new AtomicLong();
        this.studipLoads = new AtomicLong();
        try {
            ObjectName name = StudipUserProviderFactory.getObjectName(pid);
            StudipUserProviderInstance mbean = this;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                logger.debug("{} was not registered", (Object)name);
            }
            mbs.registerMBean(mbean, name);
        }
        catch (Exception e) {
            logger.error("Unable to register {} as an mbean", (Object)this, (Object)e);
        }
    }

    public String getOrganization() {
        return this.organization.getId();
    }

    public User loadUser(String userName) {
        logger.debug("loaduser(" + userName + ")");
        this.requests.incrementAndGet();
        try {
            Object user = this.cache.getUnchecked((Object)userName);
            if (user == this.nullToken) {
                logger.debug("Returning null user from cache");
                return null;
            }
            logger.debug("Returning user " + userName + " from cache");
            return (JaxbUser)user;
        }
        catch (ExecutionError e) {
            logger.warn("Exception while loading user {}", (Object)userName, (Object)e);
            return null;
        }
        catch (UncheckedExecutionException e) {
            logger.warn("Exception while loading user {}", (Object)userName, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User loadUserFromStudip(String userName) {
        if (this.cache == null) {
            throw new IllegalStateException("The Studip user detail service has not yet been configured");
        }
        if ("admin".equals(userName) || "".equals(userName) || "anonymous".equals(userName)) {
            this.cache.put((Object)userName, this.nullToken);
            logger.debug("we don't answer for: " + userName);
            return null;
        }
        logger.debug("In loadUserFromStudip, currently processing user : {}", (Object)userName);
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
        this.studipLoads.incrementAndGet();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassloader = currentThread.getContextClassLoader();
        try {
            JSONObject userJsonObj = this.getStudipUser(userName);
            if (userJsonObj == null) {
                User user = null;
                return user;
            }
            HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
            if (userJsonObj.containsKey((Object)"roles")) {
                JSONArray rolesArray = (JSONArray)userJsonObj.get((Object)"roles");
                for (Object r : rolesArray) {
                    roles.add(new JaxbRole(r.toString(), jaxbOrganization, "Studip external role", Role.Type.EXTERNAL));
                }
            }
            roles.add(new JaxbRole(STUDIP_GROUP, jaxbOrganization, "Studip Users", Role.Type.EXTERNAL_GROUP));
            logger.debug("Returning JaxbRoles: " + roles);
            String email = Objects.toString(userJsonObj.get((Object)"email"), null);
            String name = Objects.toString(userJsonObj.get((Object)"fullname"), null);
            JaxbUser user = new JaxbUser(userName, null, name, email, PROVIDER_NAME, jaxbOrganization, roles);
            this.cache.put((Object)userName, (Object)user);
            logger.debug("Returning user {}", (Object)userName);
            JaxbUser jaxbUser = user;
            return jaxbUser;
        }
        catch (ParseException e) {
            logger.error("Exception while parsing response from provider for user {}", (Object)userName, (Object)e);
            User user = null;
            return user;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            User user = null;
            return user;
        }
        catch (URISyntaxException e) {
            logger.error("Misspelled URI", (Throwable)e);
            User user = null;
            return user;
        }
        finally {
            currentThread.setContextClassLoader(originalClassloader);
        }
    }

    private JSONObject getStudipUser(String uid) throws URISyntaxException, IOException, ParseException {
        String apiPath = new URIBuilder().setPathSegments(new String[]{"opencast", "user", uid}).getPath();
        URI url = new URIBuilder(this.studipUrl).setPath(this.studipUrl.getPath().replaceAll("/*$", "") + apiPath).addParameter("token", this.studipToken).build();
        HttpGet get = new HttpGet(url);
        get.setHeader("User-Agent", OC_USERAGENT);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            JSONObject jSONObject;
            block19: {
                int statusCode;
                CloseableHttpResponse resp;
                block17: {
                    JSONObject jSONObject2;
                    block18: {
                        resp = client.execute((HttpUriRequest)get);
                        try {
                            statusCode = resp.getStatusLine().getStatusCode();
                            if (statusCode != 404) break block17;
                            jSONObject2 = null;
                            if (resp == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (resp != null) {
                                try {
                                    resp.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resp.close();
                    }
                    return jSONObject2;
                }
                if (statusCode / 100 != 2) {
                    throw new IOException("HttpRequest unsuccessful, reason: " + resp.getStatusLine().getReasonPhrase());
                }
                JSONParser parser = new JSONParser();
                BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
                Object obj = parser.parse((Reader)reader);
                if (!(obj instanceof JSONObject)) {
                    throw new IOException("StudIP responded in unexpected format");
                }
                JSONObject jObj = (JSONObject)obj;
                if (jObj.containsKey((Object)"errors")) {
                    throw new IOException("Stud.IP returned an error: " + jObj.toJSONString());
                }
                jSONObject = jObj;
                if (resp == null) break block19;
                resp.close();
            }
            return jSONObject;
        }
    }

    public float getCacheHitRatio() {
        if (this.requests.get() == 0L) {
            return 0.0f;
        }
        return (float)(this.requests.get() - this.studipLoads.get()) / (float)this.requests.get();
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (query.endsWith("%")) {
            query = query.substring(0, query.length() - 1);
        }
        if (query.isEmpty()) {
            return Collections.emptyIterator();
        }
        LinkedList<JaxbUser> users = new LinkedList<JaxbUser>();
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
        JaxbUser queryUser = new JaxbUser(query, PROVIDER_NAME, jaxbOrganization, new HashSet());
        users.add(queryUser);
        return users.iterator();
    }

    public Iterator<User> getUsers() {
        return Collections.emptyIterator();
    }

    public void invalidate(String userName) {
        this.cache.invalidate((Object)userName);
    }

    public long countUsers() {
        return 0L;
    }

    public List<Role> getRolesForUser(String userName) {
        LinkedList<Role> roles = new LinkedList<Role>();
        if ("admin".equals(userName) || "".equals(userName) || "anonymous".equals(userName)) {
            logger.debug("we don't answer for: " + userName);
            return roles;
        }
        logger.debug("getRolesForUser(" + userName + ")");
        User user = this.loadUser(userName);
        if (user != null) {
            logger.debug("Returning cached roleset for {}", (Object)userName);
            return new ArrayList<Role>(user.getRoles());
        }
        logger.debug("Return empty roleset for {} - not found on Studip");
        return new LinkedList<Role>();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        logger.debug("findRoles(query=" + query + " offset=" + offset + " limit=" + limit + ")");
        if (target == Role.Target.USER) {
            return Collections.emptyIterator();
        }
        if (query.endsWith("%")) {
            query = query.substring(0, query.length() - 1);
        }
        if (query.isEmpty()) {
            return Collections.emptyIterator();
        }
        LinkedList roles = new LinkedList();
        return roles.iterator();
    }
}

