/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.urlsigning.verifier.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.urlsigning.verifier.UrlSigningVerifier;
import org.opencastproject.urlsigning.common.ResourceRequest;
import org.opencastproject.urlsigning.utils.ResourceRequestUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, UrlSigningVerifier.class}, property={"service.description=Url Signing Verifier", "service.pid=org.opencastproject.security.urlsigning.verifier.impl.UrlSigningVerifierImpl"})
public class UrlSigningVerifierImpl
implements UrlSigningVerifier,
ManagedService {
    public static final String KEY_PREFIX = "key.";
    private static final Logger logger = LoggerFactory.getLogger(UrlSigningVerifierImpl.class);
    private Properties keys = new Properties();

    public ResourceRequest verify(String queryString, String clientIp, String baseUri) {
        return ResourceRequestUtil.resourceRequestFromQueryString((String)queryString, (String)clientIp, (String)baseUri, (Properties)this.getKeys(), (boolean)true);
    }

    public ResourceRequest verify(String queryString, String clientIp, String baseUri, boolean strict) {
        return ResourceRequestUtil.resourceRequestFromQueryString((String)queryString, (String)clientIp, (String)baseUri, (Properties)this.getKeys(), (boolean)strict);
    }

    protected Properties getKeys() {
        return this.keys;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        logger.info("Updating UrlSigningVerifierImpl");
        this.keys.clear();
        if (properties == null) {
            logger.warn("UrlSigningVerifierImpl has no keys to verify urls");
            return;
        }
        Enumeration<String> ids = properties.keys();
        while (ids.hasMoreElements()) {
            String propertyKey = ids.nextElement();
            String id = StringUtils.removeStart((String)propertyKey, (String)KEY_PREFIX);
            if (id == propertyKey) continue;
            String key = StringUtils.trimToNull((String)Objects.toString(properties.get(propertyKey), null));
            if (key == null) {
                throw new ConfigurationException(propertyKey, "can't be empty");
            }
            this.keys.setProperty(id, key);
        }
        if (this.keys.size() == 0) {
            logger.info("UrlSigningVerifierImpl configured to not verify any urls.");
            return;
        }
        logger.info("Finished updating UrlSigningVerifierImpl");
    }
}

