/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.urlsigning.filter;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.verifier.UrlSigningVerifier;
import org.opencastproject.urlsigning.common.ResourceRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(scope=ServiceScope.PROTOTYPE, property={"service.description=Url Signing Filter"})
@ServiceRanking(value=7)
@HttpWhiteboardFilterName(value="UrlSigningFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class UrlSigningFilter
implements Filter {
    public static final String URL_REGEX_PREFIX = "url.regex";
    public static final String ENABLE_FILTER_CONFIG_KEY = "enabled";
    public static final String STRICT_FILTER_CONFIG_KEY = "strict";
    private static final Logger logger = LoggerFactory.getLogger(UrlSigningFilter.class);
    private UrlSigningVerifier urlSigningVerifier;
    private List<String> urlRegularExpressions = new LinkedList<String>();
    private boolean enabled = true;
    private boolean strict = true;

    @Reference
    public void setUrlSigningVerifier(UrlSigningVerifier urlSigningVerifier) {
        this.urlSigningVerifier = urlSigningVerifier;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        if (this.urlRegularExpressions.size() == 0) {
            logger.debug("There are no regular expressions configured to protect endpoints, skipping filter.");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!"GET".equalsIgnoreCase(httpRequest.getMethod()) && !"HEAD".equalsIgnoreCase(httpRequest.getMethod())) {
            logger.debug("The request '{}' is not a GET or HEAD request so skipping the filter.", (Object)httpRequest.getRequestURL());
            chain.doFilter(request, response);
            return;
        }
        boolean matches = false;
        for (String urlRegularExpression : this.urlRegularExpressions) {
            Pattern p = Pattern.compile(urlRegularExpression);
            Matcher m = p.matcher(httpRequest.getRequestURL());
            if (!m.matches()) continue;
            matches = true;
            break;
        }
        if (!matches) {
            logger.debug("The request '{}' doesn't match any of the configured regular expressions so skipping the filter.", (Object)httpRequest.getRequestURL());
            chain.doFilter(request, response);
            return;
        }
        try {
            ResourceRequest resourceRequest = this.urlSigningVerifier.verify(httpRequest.getQueryString(), httpRequest.getRemoteAddr(), httpRequest.getRequestURL().toString(), this.strict);
            if (resourceRequest == null) {
                logger.error("Unable to process httpRequest '{}' because we got a null object as the verification.", (Object)httpRequest.getRequestURL());
                httpResponse.sendError(500, "Unable to process http request because we got a null object as the verification.");
                return;
            }
            switch (resourceRequest.getStatus()) {
                case Ok: {
                    logger.trace("The request '{}' matched a regular expression path and was accepted as a properly signed url.", (Object)httpRequest.getRequestURL());
                    chain.doFilter((ServletRequest)httpRequest, response);
                    return;
                }
                case BadRequest: {
                    logger.debug("Unable to process httpRequest '{}' because it was rejected as a Bad Request, usually a problem with query string: {}", (Object)httpRequest.getRequestURL(), (Object)resourceRequest.getRejectionReason());
                    httpResponse.sendError(400);
                    return;
                }
                case Forbidden: {
                    logger.debug("Unable to process httpRequest '{}' because is was rejected as Forbidden, usually a problem with making policy matching the signature: {}", (Object)httpRequest.getRequestURL(), (Object)resourceRequest.getRejectionReason());
                    httpResponse.sendError(403);
                    return;
                }
                case Gone: {
                    logger.debug("Unable to process httpRequest '{}' because is was rejected as Gone: {}", (Object)httpRequest.getRequestURL(), (Object)resourceRequest.getRejectionReason());
                    httpResponse.sendError(410);
                    return;
                }
            }
            logger.error("Unable to process httpRequest '{}' because is was rejected as status {} which is not a status we should be handling here. This must be due to a code change and is a bug.: {}", new Object[]{httpRequest.getRequestURL(), resourceRequest.getStatus(), resourceRequest.getRejectionReason()});
            httpResponse.sendError(500);
            return;
        }
        catch (UrlSigningException e) {
            logger.error("Unable to verify request for '{}' with query string '{}' from host '{}' because:", new Object[]{httpRequest.getRequestURL(), httpRequest.getQueryString(), httpRequest.getRemoteAddr(), e});
            httpResponse.sendError(500, String.format("%s is unable to verify request for '%s' with query string '%s' from host '%s' because: %s", this.getName(), httpRequest.getRequestURL(), httpRequest.getQueryString(), httpRequest.getRemoteAddr(), ExceptionUtils.getStackTrace((Throwable)e)));
            return;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    @Activate
    @Modified
    public void updated(Map<String, Object> properties) {
        logger.info("Updating UrlSigningFilter");
        String enableFilterConfig = (String)properties.get(ENABLE_FILTER_CONFIG_KEY);
        if (enableFilterConfig != null) {
            this.enabled = Boolean.parseBoolean(enableFilterConfig);
            if (this.enabled) {
                logger.info("The UrlSigningFilter is configured to be enabled.");
            } else {
                logger.info("The UrlSigningFilter is configured to be disabled.");
            }
        } else {
            this.enabled = true;
            logger.info("The UrlSigningFilter is enabled by default. Use the '{}' property in its properties file to enable or disable it.", (Object)ENABLE_FILTER_CONFIG_KEY);
        }
        String strictFilterConfig = (String)properties.get(STRICT_FILTER_CONFIG_KEY);
        if (strictFilterConfig != null) {
            this.strict = Boolean.parseBoolean(strictFilterConfig);
            if (this.strict) {
                logger.info("The UrlSigningFilter is configured to use strict checking of resource URLs.");
            } else {
                logger.info("The UrlSigningFilter is configured to not use strict checking of resource URLs.");
            }
        } else {
            this.strict = true;
            logger.info("The UrlSigningFilter is using strict checking of resource URLs by default. Use the '{}' property in its properties file to enable or disable it.", (Object)STRICT_FILTER_CONFIG_KEY);
        }
        this.urlRegularExpressions.clear();
        if (properties == null) {
            logger.warn("UrlSigningFilter has no paths to match");
            return;
        }
        for (String propertyKey : properties.keySet()) {
            if (!propertyKey.startsWith(URL_REGEX_PREFIX)) continue;
            String urlRegularExpression = StringUtils.trimToNull((String)((String)properties.get(propertyKey)));
            logger.debug("Looking for configuration of {} and found '{}'", (Object)propertyKey, (Object)urlRegularExpression);
            if (urlRegularExpression == null) {
                logger.debug("Unable to configure url regular expression with id '{}' because it is missing. Stopping to look for new keys.", (Object)propertyKey);
                break;
            }
            this.urlRegularExpressions.add(urlRegularExpression);
        }
        if (this.urlRegularExpressions.size() == 0) {
            logger.info("UrlSigningFilter configured to not verify any urls.");
            return;
        }
        logger.info("Finished updating UrlSigningFilter");
    }
}

