/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.urlsigning.utils;

import java.util.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlSigningServiceOsgiUtil {
    private static final Logger logger = LoggerFactory.getLogger(UrlSigningServiceOsgiUtil.class);
    public static final String URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY = "url.signing.expires.seconds";
    public static final String URL_SIGNING_USE_CLIENT_IP = "url.signing.use.client.ip";
    public static final long DEFAULT_URL_SIGNING_EXPIRE_DURATION = 7200L;
    public static final Boolean DEFAULT_SIGN_WITH_CLIENT_IP = false;

    private UrlSigningServiceOsgiUtil() {
    }

    public static long getUpdatedSigningExpiration(Dictionary properties, String className) {
        return UrlSigningServiceOsgiUtil.getUpdatedSigningExpiration(properties, className, URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY, 7200L);
    }

    public static long getUpdatedSigningExpiration(Dictionary properties, String className, String key, long defaultExpiry) {
        long expireSeconds = defaultExpiry;
        Object dictionaryValue = properties.get(URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY);
        if (dictionaryValue != null) {
            try {
                expireSeconds = Long.parseLong(dictionaryValue.toString());
                logger.info("For the class {} the property '{}' has been configured to expire signed URLs in {} seconds.", new Object[]{className, URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY, expireSeconds});
            }
            catch (NumberFormatException e) {
                logger.warn("For the class {} unable to parse when a stream should expire from '{}' so using default '{}' because:", new Object[]{className, dictionaryValue, defaultExpiry, e});
                expireSeconds = defaultExpiry;
            }
        } else {
            logger.debug("For the class {} the property '{}' has not been configured, so the default is being used to expire signed URLs in {} seconds.", new Object[]{className, URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY, expireSeconds});
        }
        return expireSeconds;
    }

    public static boolean getUpdatedSignWithClientIP(Dictionary properties, String className) {
        return UrlSigningServiceOsgiUtil.getUpdatedSignWithClientIP(properties, className, URL_SIGNING_USE_CLIENT_IP, DEFAULT_SIGN_WITH_CLIENT_IP);
    }

    public static boolean getUpdatedSignWithClientIP(Dictionary properties, String className, String key, boolean defaultSignWithIP) {
        boolean signWithClientIP = defaultSignWithIP;
        Object dictionaryValue = properties.get(URL_SIGNING_USE_CLIENT_IP);
        if (dictionaryValue != null) {
            signWithClientIP = Boolean.parseBoolean(dictionaryValue.toString());
            if (signWithClientIP) {
                logger.info("For the class {} the property '{}' has been configured to sign urls with the client IP.", (Object)className, (Object)URL_SIGNING_USE_CLIENT_IP);
            } else {
                logger.info("For the class {} the property '{}' has been configured to not sign urls with the client IP.", (Object)className, (Object)URL_SIGNING_USE_CLIENT_IP);
            }
        } else {
            logger.debug("For the class {} the property '{}' has not been configured, so the default of signing urls with the client ip is {}.", new Object[]{className, URL_SIGNING_USE_CLIENT_IP, signWithClientIP});
        }
        return signWithClientIP;
    }
}

