/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.ibmwatson.endpoint;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.transcription.ibmwatson.IBMWatsonTranscriptionService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="IBMWatsonTranscriptionRestService", title="Transcription Service REST Endpoint (uses IBM Watson services)", abstractText="Uses external service to generate transcriptions of recordings.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/transcription)"})
@Component(immediate=true, service={IBMWatsonTranscriptionRestService.class}, property={"service.description=IBM Watson Transcription REST Endpoint", "opencast.service.type=org.opencastproject.transcription.ibmwatson", "opencast.service.path=/transcripts/watson", "opencast.service.jobproducer=true"})
public class IBMWatsonTranscriptionRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IBMWatsonTranscriptionRestService.class);
    protected IBMWatsonTranscriptionService service;
    protected ServiceRegistry serviceRegistry = null;

    @Activate
    public void activate(ComponentContext cc) {
    }

    @Reference
    public void setTranscriptionService(IBMWatsonTranscriptionService service) {
        this.service = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry service) {
        this.serviceRegistry = service;
    }

    public JobProducer getService() {
        return this.service;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @GET
    @Path(value="results")
    @Produces(value={"text/plain"})
    @RestQuery(name="results", description="Called by the speech-to-text service when registering the callback url", returnDescription="Echo the string sent.", restParameters={@RestParameter(name="challenge_string", description="String to be echoed in the response body", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="If no errors"), @RestResponse(responseCode=500, description="An error occurred")})
    public Response checkCallbackUrl(@QueryParam(value="challenge_string") String challengeString, @Context HttpServletRequest request) {
        logger.debug("==== checkCallback got called: challenge_string is '{}'", (Object)challengeString);
        Enumeration en = request.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            logger.debug("==== {}: {}", (Object)name, (Object)request.getHeader(name));
        }
        return Response.ok((Object)challengeString).type("text/plain").build();
    }

    @POST
    @Path(value="results")
    @Produces(value={"text/plain"})
    @RestQuery(name="results", description="Called by the speech-to-text service to report status.", returnDescription="", responses={@RestResponse(responseCode=200, description="Got notification!")})
    public Response reportStatus(String body) {
        logger.trace("Body is: " + body);
        JSONObject jsonObj = null;
        try {
            JSONParser parser = new JSONParser();
            jsonObj = (JSONObject)parser.parse(body);
            String mpId = (String)jsonObj.get((Object)"user_token");
            String event = (String)jsonObj.get((Object)"event");
            logger.info("Transcription notification for mp {} is {}", (Object)mpId, (Object)event);
            if ("recognitions.completed_with_results".equals(event)) {
                this.service.transcriptionDone(mpId, jsonObj);
            } else if ("recognitions.failed".equals(event)) {
                this.service.transcriptionError(mpId, jsonObj);
            }
            return Response.ok().type("application/json").build();
        }
        catch (ParseException e) {
            logger.warn("{} occurred. Notification results could not be parsed: {}", ((Object)((Object)e)).getClass(), jsonObj == null ? jsonObj : jsonObj.toJSONString());
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.warn("Error handling notification results: {}", (Object)e.getMessage());
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }
}

