/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.textextractor.tesseract;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.textextractor.api.TextExtractor;
import org.opencastproject.textextractor.api.TextExtractorException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TextExtractor.class, ManagedService.class}, property={"service.description=Tesseract Text Extractor"})
public class TesseractTextExtractor
implements TextExtractor,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(TesseractTextExtractor.class);
    public static final String TESSERACT_BINARY_DEFAULT = "tesseract";
    public static final String TESSERACT_BINARY_CONFIG_KEY = "org.opencastproject.textanalyzer.tesseract.path";
    public static final String TESSERACT_OPTS_CONFIG_KEY = "org.opencastproject.textanalyzer.tesseract.options";
    private String binary;
    private String addOptions = "";
    private static final List<String> stderrFilter = Arrays.asList("Page", "Tesseract Open Source OCR Engine", "Warning: Invalid resolution 0 dpi. Using 70 instead.", "Estimating resolution as ");

    public TesseractTextExtractor() {
        this(TESSERACT_BINARY_DEFAULT);
    }

    public TesseractTextExtractor(String binary) {
        this.binary = binary;
    }

    public void setAdditionalOptions(String addOptions) {
        this.addOptions = addOptions;
    }

    public String getAdditionalOptions() {
        return this.addOptions;
    }

    public List<String> extract(File image) throws TextExtractorException {
        ArrayList<String> arrayList;
        if (this.binary == null) {
            throw new IllegalStateException("Binary is not set");
        }
        File outputFile = null;
        File outputFileBase = new File(image.getParentFile(), FilenameUtils.getBaseName((String)image.getName()));
        List<String> command = this.getTesseractCommand(image, outputFileBase);
        logger.info("Running Tesseract: {}", command);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process tesseractProcess = processBuilder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(tesseractProcess.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    String trimmedLine = line.trim();
                    if (stderrFilter.parallelStream().noneMatch(trimmedLine::startsWith)) {
                        logger.info(line);
                        continue;
                    }
                    logger.debug(line);
                }
            }
            int exitCode = tesseractProcess.waitFor();
            if (exitCode != 0) {
                throw new TextExtractorException("Tesseract exited abnormally with status " + exitCode);
            }
            outputFile = new File(outputFileBase.getAbsolutePath() + ".txt");
            ArrayList<String> output = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outputFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String trimmedLine = line.trim();
                    if (trimmedLine.isEmpty()) continue;
                    output.add(trimmedLine);
                }
            }
            arrayList = output;
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new TextExtractorException("Error running text extractor " + this.binary, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(outputFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)outputFile);
        return arrayList;
    }

    private List<String> getTesseractCommand(File image, File outputFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.binary);
        args.add(image.getAbsolutePath());
        args.add(outputFile.getAbsolutePath());
        args.addAll(Arrays.asList(StringUtils.split((String)this.addOptions)));
        return args;
    }

    public void updated(Dictionary properties) {
        String addopts;
        String path = (String)properties.get(TESSERACT_BINARY_CONFIG_KEY);
        if (path != null) {
            logger.info("Setting Tesseract path to {}", (Object)path);
            this.binary = path;
        }
        if ((addopts = (String)properties.get(TESSERACT_OPTS_CONFIG_KEY)) != null) {
            logger.info("Setting additional options for Tesseract path to '{}'", (Object)addopts);
            this.addOptions = addopts;
        }
    }

    public void activate(ComponentContext cc) {
        String path = cc.getBundleContext().getProperty(TESSERACT_BINARY_CONFIG_KEY);
        if (path == null) {
            logger.debug("DEFAULT org.opencastproject.textanalyzer.tesseract.path: tesseract");
        } else {
            this.binary = path;
            logger.info("Setting Tesseract path to binary from config: {}", (Object)path);
        }
        String addopts = cc.getBundleContext().getProperty(TESSERACT_OPTS_CONFIG_KEY);
        if (addopts != null) {
            logger.info("Setting additional options for Tesseract to '{}'", (Object)addopts);
            this.addOptions = addopts;
        } else {
            logger.info("No additional options for Tesseract");
            this.addOptions = "";
        }
    }
}

