/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.textanalyzer.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.textanalyzer.api.TextAnalyzerException;
import org.opencastproject.textanalyzer.api.TextAnalyzerService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TextAnalyzerService.class}, property={"service.description=Text Analysis Remote Service Proxy"})
public class TextAnalysisRemoteImpl
extends RemoteBase
implements TextAnalyzerService {
    private static final Logger logger = LoggerFactory.getLogger(TextAnalysisRemoteImpl.class);

    public TextAnalysisRemoteImpl() {
        super("org.opencastproject.textanalyzer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job extract(Attachment image) throws TextAnalyzerException {
        HttpPost post = new HttpPost();
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("image", MediaPackageElementParser.getAsXml((MediaPackageElement)image)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new TextAnalyzerException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Analyzing {} on a remote analysis server", (Object)image);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new TextAnalyzerException("Unable to analyze element '" + image + "' using a remote analysis service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new TextAnalyzerException("Unable to analyze element '" + image + "' using a remote analysis service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

