/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.export.impl;

import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.io.StringWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.export.api.DetailLevel;
import org.opencastproject.statistics.export.api.StatisticsExportService;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.functions.Misc;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, StatisticsExportService.class}, property={"service.description=Statistics Export Service"})
public class StatisticsExportServiceImpl
implements StatisticsExportService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsExportServiceImpl.class);
    private static final String[] header = new String[]{"ID", "Name", "Date", "Value"};
    private static final String CFG_KEY_SERIES_TO_EVENT_PROVIDER_MAPPINGS = "series.to.event.provider.mappings";
    private static final String CFG_KEY_ORGANIZATION_TO_EVENT_PROVIDER_MAPPINGS = "organization.to.event.provider.mappings";
    private static final String CFG_KEY_ORGANIZATION_TO_SERIES_PROVIDER_MAPPINGS = "organization.to.series.provider.mappings";
    private Map<String, String> seriesToEventProviderMapping = new HashMap<String, String>();
    private Map<String, String> organizationToEventProviderMapping = new HashMap<String, String>();
    private Map<String, String> organizationToSeriesProviderMapping = new HashMap<String, String>();
    private IndexService indexService;
    private SecurityService securityService;
    private StatisticsService statisticsService;
    private AssetManager assetManager;

    public void updated(Dictionary<String, ?> dictionary) {
        String organizationToSeriesProviderMappings;
        String organizationToEventProviderMappings;
        String seriesToEventProviderMappings = (String)dictionary.get(CFG_KEY_SERIES_TO_EVENT_PROVIDER_MAPPINGS);
        if (seriesToEventProviderMappings != null) {
            this.seriesToEventProviderMapping = this.getMapping(seriesToEventProviderMappings);
        }
        if ((organizationToEventProviderMappings = (String)dictionary.get(CFG_KEY_ORGANIZATION_TO_EVENT_PROVIDER_MAPPINGS)) != null) {
            this.organizationToEventProviderMapping = this.getMapping(organizationToEventProviderMappings);
        }
        if ((organizationToSeriesProviderMappings = (String)dictionary.get(CFG_KEY_ORGANIZATION_TO_SERIES_PROVIDER_MAPPINGS)) != null) {
            this.organizationToSeriesProviderMapping = this.getMapping(organizationToSeriesProviderMappings);
        }
    }

    private Map<String, String> getMapping(String seriesProviderMappings) {
        return Arrays.stream(seriesProviderMappings.split(",")).peek(s -> {
            if (!s.contains(":")) {
                throw new ConfigurationException("Missing ':' in mapping between providers: " + s);
            }
        }).collect(Collectors.toMap(s -> s.split(":")[0], s -> s.split(":")[1]));
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating Statistics Service");
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating Statistics Service");
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    public void setStatisticsService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    private static String formatDate(String dateStr, DataResolution dataResolution, ZoneId zoneId) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.parse(dateStr), zoneId);
        DateTimeFormatter formatter = null;
        switch (dataResolution) {
            case HOURLY: {
                formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:00");
                return formatter.format(ldt);
            }
            case DAILY: {
                formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd");
                return formatter.format(ldt);
            }
            case WEEKLY: {
                formatter = DateTimeFormatter.ofPattern("uuuu-ww");
                return formatter.format(ldt);
            }
            case MONTHLY: {
                formatter = DateTimeFormatter.ofPattern("uuuu-MM");
                return formatter.format(ldt);
            }
            case YEARLY: {
                formatter = DateTimeFormatter.ofPattern("uuuu");
                return formatter.format(ldt);
            }
        }
        throw new IllegalStateException("Unexpected value: " + dataResolution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCSV(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId) throws SearchIndexException, UnauthorizedException, NotFoundException {
        if (!(provider instanceof TimeSeriesProvider)) {
            throw new IllegalStateException("CSV export not supported for provider of type " + provider.getClass().getName());
        }
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = CSVFormat.RFC4180.print((Appendable)stringWriter);){
            switch (provider.getResourceType()) {
                case EPISODE: {
                    this.printEvent(provider, resourceId, from, to, dataResolution, index, zoneId, printer, false, 0, 0);
                    return stringWriter.toString();
                }
                case SERIES: {
                    if (this.seriesToEventProviderMapping.containsKey(provider.getId())) {
                        this.printSeriesEvents(provider, resourceId, from, to, dataResolution, index, zoneId, printer, false, 0, 0, Collections.emptyMap());
                        return stringWriter.toString();
                    } else {
                        this.printSeries(provider, resourceId, from, to, dataResolution, index, zoneId, printer, false, 0, 0);
                        return stringWriter.toString();
                    }
                }
                case ORGANIZATION: {
                    if (this.organizationToEventProviderMapping.containsKey(provider.getId())) {
                        this.printOrganizationEvents(provider, resourceId, from, to, dataResolution, index, zoneId, printer, false, 0, 0, Collections.emptyMap());
                        return stringWriter.toString();
                    } else if (this.organizationToSeriesProviderMapping.containsKey(provider.getId())) {
                        this.printOrganizationSeries(provider, resourceId, from, to, dataResolution, index, zoneId, printer, false, 0, 0, Collections.emptyMap());
                        return stringWriter.toString();
                    } else {
                        this.printOrganization(provider, resourceId, from, to, dataResolution, zoneId, printer, 0, 0);
                        return stringWriter.toString();
                    }
                }
                default: {
                    throw new IllegalStateException("Unknown resource type: " + provider.getResourceType().name());
                }
            }
        }
        catch (IOException e) {
            return (String)Misc.chuck((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCSV(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, boolean fullMetadata, DetailLevel detailLevel, int limit, int offset, Map<String, String> filters) throws SearchIndexException, UnauthorizedException, NotFoundException {
        if (!(provider instanceof TimeSeriesProvider)) {
            throw new IllegalStateException("CSV export not supported for provider of type " + provider.getClass().getName());
        }
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = CSVFormat.RFC4180.print((Appendable)stringWriter);){
            switch (provider.getResourceType()) {
                case EPISODE: {
                    this.printEvent(provider, resourceId, from, to, dataResolution, index, zoneId, printer, fullMetadata, limit, offset);
                    return stringWriter.toString();
                }
                case SERIES: {
                    if (detailLevel == DetailLevel.EPISODE) {
                        this.printSeriesEvents(provider, resourceId, from, to, dataResolution, index, zoneId, printer, fullMetadata, limit, offset, filters);
                        return stringWriter.toString();
                    } else {
                        this.printSeries(provider, resourceId, from, to, dataResolution, index, zoneId, printer, fullMetadata, limit, offset);
                        return stringWriter.toString();
                    }
                }
                case ORGANIZATION: {
                    if (detailLevel == DetailLevel.EPISODE) {
                        this.printOrganizationEvents(provider, resourceId, from, to, dataResolution, index, zoneId, printer, fullMetadata, limit, offset, filters);
                        return stringWriter.toString();
                    } else if (detailLevel == DetailLevel.SERIES) {
                        this.printOrganizationSeries(provider, resourceId, from, to, dataResolution, index, zoneId, printer, fullMetadata, limit, offset, filters);
                        return stringWriter.toString();
                    } else {
                        this.printOrganization(provider, resourceId, from, to, dataResolution, zoneId, printer, limit, offset);
                        return stringWriter.toString();
                    }
                }
                default: {
                    throw new IllegalStateException("Unknown resource type: " + provider.getResourceType().name());
                }
            }
        }
        catch (IOException e) {
            return (String)Misc.chuck((Throwable)e);
        }
    }

    private void printEvent(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, CSVPrinter printer, boolean fullMetaData, int limit, int offset) throws IOException, SearchIndexException, NotFoundException {
        if (offset != 0) {
            return;
        }
        Opt event = this.indexService.getEvent(resourceId, index);
        if (!event.isSome()) {
            throw new NotFoundException("Event not found in index: " + resourceId);
        }
        TimeSeries dataEvent = this.statisticsService.getTimeSeriesData(provider, resourceId, from, to, dataResolution, zoneId);
        if (fullMetaData) {
            this.printFullEventData(printer, dataEvent, dataResolution, resourceId, zoneId, true);
        } else {
            StatisticsExportServiceImpl.printData(printer, dataEvent, dataResolution, resourceId, ((Event)event.get()).getTitle(), zoneId, true);
        }
    }

    private void printSeries(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, CSVPrinter printer, boolean fullMetadata, int limit, int offset) throws SearchIndexException, NotFoundException, IOException {
        if (offset != 0) {
            return;
        }
        Optional series = index.getSeries(resourceId, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (!series.isPresent()) {
            throw new NotFoundException("Series not found in index: " + resourceId);
        }
        TimeSeries dataSeries = this.statisticsService.getTimeSeriesData(provider, resourceId, from, to, dataResolution, zoneId);
        if (fullMetadata) {
            this.printFullSeriesData(printer, dataSeries, dataResolution, resourceId, zoneId, true);
        } else {
            StatisticsExportServiceImpl.printData(printer, dataSeries, dataResolution, resourceId, ((Series)series.get()).getTitle(), zoneId, true);
        }
    }

    private void printSeriesEvents(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, CSVPrinter printer, boolean fullMetadata, int limit, int offset, Map<String, String> filters) throws SearchIndexException, IOException {
        String eventProviderId = this.seriesToEventProviderMapping.get(provider.getId());
        StatisticsProvider eventProvider = (StatisticsProvider)this.statisticsService.getProvider(eventProviderId).orElseThrow(() -> new IllegalStateException("The configured provider " + eventProviderId + " is not available."));
        EventSearchQuery query = (EventSearchQuery)new EventSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withSeriesId(resourceId).withLimit(limit).withOffset(offset);
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            query = (EventSearchQuery)StatisticsExportServiceImpl.applyFilter(filter.getKey(), filter.getValue(), query);
        }
        SearchResult result = index.getByQuery(query);
        boolean first = offset == 0;
        for (SearchResultItem currentEvent : result.getItems()) {
            TimeSeries dataEvent = this.statisticsService.getTimeSeriesData(eventProvider, ((Event)currentEvent.getSource()).getIdentifier(), from, to, dataResolution, zoneId);
            if (fullMetadata) {
                this.printFullEventData(printer, dataEvent, dataResolution, ((Event)currentEvent.getSource()).getIdentifier(), zoneId, first);
            } else {
                StatisticsExportServiceImpl.printData(printer, dataEvent, dataResolution, ((Event)currentEvent.getSource()).getIdentifier(), ((Event)currentEvent.getSource()).getTitle(), zoneId, first);
            }
            first = false;
        }
    }

    private void printOrganization(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ZoneId zoneId, CSVPrinter printer, int limit, int offset) throws UnauthorizedException, IOException {
        if (offset != 0) {
            return;
        }
        Organization organization = this.securityService.getOrganization();
        if (!resourceId.equals(organization.getId())) {
            throw new UnauthorizedException("Can only export CSV statistics for own organization.");
        }
        TimeSeries dataOrg = this.statisticsService.getTimeSeriesData(provider, resourceId, from, to, dataResolution, zoneId);
        StatisticsExportServiceImpl.printData(printer, dataOrg, dataResolution, resourceId, organization.getName(), zoneId, true);
    }

    private void printOrganizationEvents(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, CSVPrinter printer, boolean fullMetadata, int limit, int offset, Map<String, String> filters) throws UnauthorizedException, SearchIndexException, IOException {
        Organization organization = this.securityService.getOrganization();
        if (!resourceId.equals(organization.getId())) {
            throw new UnauthorizedException("Can only export CSV statistics for own organization.");
        }
        String eventProviderId = this.organizationToEventProviderMapping.get(provider.getId());
        StatisticsProvider eventProvider = (StatisticsProvider)this.statisticsService.getProvider(eventProviderId).orElseThrow(() -> new IllegalStateException("The configured provider " + eventProviderId + " is not available."));
        EventSearchQuery query = (EventSearchQuery)new EventSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withLimit(limit).withOffset(offset);
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            query = (EventSearchQuery)StatisticsExportServiceImpl.applyFilter(filter.getKey(), filter.getValue(), query);
        }
        SearchResult result = index.getByQuery(query);
        boolean first = offset == 0;
        for (SearchResultItem currentEvent : result.getItems()) {
            TimeSeries dataEvent = this.statisticsService.getTimeSeriesData(eventProvider, ((Event)currentEvent.getSource()).getIdentifier(), from, to, dataResolution, zoneId);
            if (fullMetadata) {
                this.printFullEventData(printer, dataEvent, dataResolution, ((Event)currentEvent.getSource()).getIdentifier(), zoneId, first);
            } else {
                StatisticsExportServiceImpl.printData(printer, dataEvent, dataResolution, ((Event)currentEvent.getSource()).getIdentifier(), ((Event)currentEvent.getSource()).getTitle(), zoneId, first);
            }
            first = false;
        }
    }

    private void printOrganizationSeries(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution dataResolution, ElasticsearchIndex index, ZoneId zoneId, CSVPrinter printer, boolean fullMetadata, int limit, int offset, Map<String, String> filters) throws UnauthorizedException, SearchIndexException, IOException {
        Organization organization = this.securityService.getOrganization();
        if (!resourceId.equals(organization.getId())) {
            throw new UnauthorizedException("Can only export CSV statistics for own organization.");
        }
        String seriesProviderId = this.organizationToSeriesProviderMapping.get(provider.getId());
        StatisticsProvider seriesProvider = (StatisticsProvider)this.statisticsService.getProvider(seriesProviderId).orElseThrow(() -> new IllegalStateException("The configured provider " + seriesProviderId + " is not available."));
        SeriesSearchQuery query = (SeriesSearchQuery)new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withLimit(limit).withOffset(offset);
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            query = (SeriesSearchQuery)StatisticsExportServiceImpl.applyFilter(filter.getKey(), filter.getValue(), query);
        }
        SearchResult result = index.getByQuery(query);
        boolean first = offset == 0;
        for (SearchResultItem currentSeries : result.getItems()) {
            TimeSeries dataEvent = this.statisticsService.getTimeSeriesData(seriesProvider, ((Series)currentSeries.getSource()).getIdentifier(), from, to, dataResolution, zoneId);
            if (fullMetadata) {
                this.printFullSeriesData(printer, dataEvent, dataResolution, ((Series)currentSeries.getSource()).getIdentifier(), zoneId, first);
            } else {
                StatisticsExportServiceImpl.printData(printer, dataEvent, dataResolution, ((Series)currentSeries.getSource()).getIdentifier(), ((Series)currentSeries.getSource()).getTitle(), zoneId, first);
            }
            first = false;
        }
    }

    private static void printData(CSVPrinter printer, TimeSeries data, DataResolution dataResolution, String resourceId, String title, ZoneId zoneId, boolean printHeader) throws IOException {
        if (printHeader) {
            printer.printRecord((Object[])header);
        }
        for (int i = 0; i < data.getLabels().size(); ++i) {
            printer.printRecord(new Object[]{resourceId, title, StatisticsExportServiceImpl.formatDate((String)data.getLabels().get(i), dataResolution, zoneId), data.getValues().get(i)});
        }
    }

    private static void printFullData(CSVPrinter printer, TimeSeries data, DataResolution dataResolution, String resourceId, ZoneId zoneId, List<MetadataField> mdfs) throws IOException {
        for (int i = 0; i < data.getLabels().size(); ++i) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(resourceId);
            values.addAll(mdfs.stream().map(f -> f.getValue() == null ? "" : f.getValue()).collect(Collectors.toList()));
            values.add(StatisticsExportServiceImpl.formatDate((String)data.getLabels().get(i), dataResolution, zoneId));
            values.add((String)data.getValues().get(i));
            printer.printRecord(values.toArray());
        }
    }

    private void printFullEventData(CSVPrinter printer, TimeSeries data, DataResolution dataResolution, String resourceId, ZoneId zoneId, boolean printHeader) throws IOException {
        List<MetadataField> mdfs = this.getEventMetadata(resourceId);
        if (printHeader) {
            printer.printRecord(StatisticsExportServiceImpl.getFullHeader(mdfs));
        }
        StatisticsExportServiceImpl.printFullData(printer, data, dataResolution, resourceId, zoneId, mdfs);
    }

    private void printFullSeriesData(CSVPrinter printer, TimeSeries data, DataResolution dataResolution, String resourceId, ZoneId zoneId, boolean printHeader) throws IOException {
        List<MetadataField> mdfs = this.getSeriesMetadata(resourceId);
        if (printHeader) {
            printer.printRecord(StatisticsExportServiceImpl.getFullHeader(mdfs));
        }
        StatisticsExportServiceImpl.printFullData(printer, data, dataResolution, resourceId, zoneId, mdfs);
    }

    private static List<String> getFullHeader(List<MetadataField> mdfs) {
        ArrayList<String> header = new ArrayList<String>();
        header.add("ID");
        header.addAll(mdfs.stream().map(MetadataField::getInputID).collect(Collectors.toList()));
        header.add("Date");
        header.add("Value");
        return header;
    }

    private List<MetadataField> getSeriesMetadata(String resourceId) {
        List mdcs = this.indexService.getSeriesCatalogUIAdapters().stream().filter(a -> !a.equals(this.indexService.getCommonSeriesCatalogUIAdapter())).filter(a -> !a.getFlavor().equals((Object)this.indexService.getCommonSeriesCatalogUIAdapter().getFlavor())).map(adapter -> adapter.getFields(resourceId)).filter(Opt::isSome).map(Opt::get).collect(Collectors.toList());
        if (this.indexService.getCommonSeriesCatalogUIAdapter().getFields(resourceId).isSome()) {
            mdcs.add(0, (DublinCoreMetadataCollection)this.indexService.getCommonSeriesCatalogUIAdapter().getFields(resourceId).get());
        }
        return mdcs.stream().map(DublinCoreMetadataCollection::getFields).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MetadataField> getEventMetadata(String resourceId) {
        Optional optMp = this.assetManager.getMediaPackage(resourceId);
        if (optMp.isEmpty()) {
            return Collections.emptyList();
        }
        List mdcs = this.indexService.getEventCatalogUIAdapters().stream().filter(a -> !a.equals(this.indexService.getCommonEventCatalogUIAdapter())).filter(a -> !a.getFlavor().equals((Object)this.indexService.getCommonEventCatalogUIAdapter().getFlavor())).map(adapter -> adapter.getFields((MediaPackage)optMp.get())).collect(Collectors.toList());
        mdcs.add(0, this.indexService.getCommonEventCatalogUIAdapter().getFields((MediaPackage)optMp.get()));
        return mdcs.stream().map(DublinCoreMetadataCollection::getFields).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static SearchQuery applyFilter(String name, String value, EventSearchQuery query) {
        if ("presenters".equals(name)) {
            return query.withPresenter(value);
        }
        if ("creator".equals(name)) {
            return query.withCreator(value);
        }
        if ("contributors".equals(name)) {
            return query.withContributor(value);
        }
        if ("location".equals(name)) {
            return query.withLocation(value);
        }
        if ("textFilter".equals(name)) {
            return query.withText("*" + value + "*");
        }
        if ("series".equals(name)) {
            return query.withSeriesId(value);
        }
        if ("subject".equals(name)) {
            return query.withSubject(value);
        }
        if ("title".equals(name)) {
            return query.withTitle(value);
        }
        if ("description".equals(name)) {
            return query.withDescription(value);
        }
        if ("series_name".equals(name)) {
            return query.withSeriesName(value);
        }
        if ("language".equals(name)) {
            return query.withLanguage(value);
        }
        if ("created".equals(name)) {
            return query.withCreated(value);
        }
        if ("license".equals(name)) {
            return query.withLicense(value);
        }
        if ("rightsholder".equals(name)) {
            return query.withRights(value);
        }
        if ("is_part_of".equals(name)) {
            return query.withSeriesId(value);
        }
        if ("source".equals(name)) {
            return query.withSource(value);
        }
        if ("status".equals(name)) {
            return query.withEventStatus(value);
        }
        if ("agent_id".equals(name)) {
            return query.withAgentId(value);
        }
        if ("publisher".equals(name)) {
            return query.withPublisher(value);
        }
        throw new IllegalArgumentException("Unknown filter :" + name);
    }

    private static SearchQuery applyFilter(String name, String value, SeriesSearchQuery query) {
        if ("contributors".equals(name)) {
            return query.withContributor(value);
        }
        if ("creator".equals(name)) {
            return query.withCreator(value);
        }
        if ("textFilter".equals(name)) {
            return query.withText("*" + value + "*");
        }
        if ("subject".equals(name)) {
            return query.withSubject(value);
        }
        if ("title".equals(name)) {
            return query.withTitle(value);
        }
        if ("description".equals(name)) {
            return query.withDescription(value);
        }
        if ("language".equals(name)) {
            return query.withLanguage(value);
        }
        if ("license".equals(name)) {
            return query.withLicense(value);
        }
        if ("publisher".equals(name)) {
            return query.withPublisher(value);
        }
        if ("organizer".equals(name)) {
            return query.withOrganizer(value);
        }
        if ("rightsholder".equals(name)) {
            return query.withRightsHolder(value);
        }
        throw new IllegalArgumentException("Unknown filter :" + name);
    }
}

