/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fsresources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencastproject.security.api.StaticFileAuthorization;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Simple Configurable StaticFileAuthorization"}, immediate=true, service={StaticFileAuthorization.class})
public class SimpleConfigurableStaticFileAuthorization
implements StaticFileAuthorization {
    private static final Logger logger = LoggerFactory.getLogger(SimpleConfigurableStaticFileAuthorization.class);
    private static final Pattern ALLOW_PATTERN = Pattern.compile("^allow\\.([^.]+)\\.pattern$");
    private List<Pattern> patterns = Collections.emptyList();

    @Activate
    public void activate(ComponentContext cc) {
        ArrayList<Pattern> newPattern = new ArrayList<Pattern>();
        if (cc != null) {
            Enumeration keys = cc.getProperties().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Matcher matcher = ALLOW_PATTERN.matcher(key);
                if (!matcher.matches()) continue;
                String patternString = Objects.toString(cc.getProperties().get(key));
                newPattern.add(Pattern.compile(patternString));
                logger.debug("Always allowing access to {}", (Object)patternString);
            }
        }
        this.patterns = newPattern;
        logger.info("Started authentication handler for {}", this.patterns);
    }

    public List<Pattern> getProtectedUrlPattern() {
        return this.patterns;
    }

    public boolean verifyUrlAccess(String path) {
        return true;
    }
}

