/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.speechtotext.api.SpeechToTextEngine;
import org.opencastproject.speechtotext.api.SpeechToTextService;
import org.opencastproject.speechtotext.api.SpeechToTextServiceException;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SpeechToTextService.class}, property={"service.description=Speech to Text Service", "service.pid=org.opencastproject.speechtotext.impl.SpeechToTextServiceImpl"})
public class SpeechToTextServiceImpl
extends AbstractJobProducer
implements SpeechToTextService {
    private static final Logger logger = LoggerFactory.getLogger(SpeechToTextServiceImpl.class);
    private SpeechToTextEngine speechToTextEngine;
    private static final String JOB_LOAD_CONFIG = "job.load.speechtotext";
    private static final float JOB_LOAD_DEFAULT = 0.8f;
    private float jobLoad = 0.8f;
    private static final String OPERATION = "speechtotext";
    private static final String COLLECTION = "subtitles";
    private static final String TMP_PREFIX = "tmp_";
    private Workspace workspace;
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;

    public SpeechToTextServiceImpl() {
        super("org.opencastproject.speechtotext");
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        logger.debug("Activated/Modified speech to text service");
        Dictionary properties = cc.getProperties();
        this.jobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)JOB_LOAD_CONFIG, (Float)Float.valueOf(0.8f), (ServiceRegistry)this.serviceRegistry);
        logger.debug("Finished activating/updating speech-to-text service");
    }

    protected String process(Job job) throws Exception {
        URI subtitleFilesURI;
        logger.debug("Started processing job {}", (Object)job.getId());
        if (!OPERATION.equals(job.getOperation())) {
            throw new ServiceRegistryException(String.format("This service can't handle operations of type '%s'", job.getOperation()));
        }
        List arguments = job.getArguments();
        String language = (String)arguments.get(1);
        URI mediaFile = new URI((String)arguments.get(0));
        Boolean translate = BooleanUtils.toBooleanObject((String)((String)arguments.get(2)));
        if (translate == null) {
            translate = false;
        }
        String name = String.format("job-%d", job.getId());
        File jobDir = Path.of(this.workspace.rootDirectory(), "collection", COLLECTION, name).toFile();
        try {
            jobDir.mkdirs();
            SpeechToTextEngine.Result result = this.speechToTextEngine.generateSubtitlesFile(this.workspace.get(mediaFile), jobDir, language, translate);
            language = result.getLanguage();
            String outputName = String.format("%d-%s.vtt", job.getId(), FilenameUtils.getBaseName((String)mediaFile.getPath()));
            try (FileInputStream in = new FileInputStream(result.getSubtitleFile());){
                subtitleFilesURI = this.workspace.putInCollection(COLLECTION, outputName, (InputStream)in);
            }
        }
        catch (Exception e) {
            throw new SpeechToTextServiceException("Error while generating subtitle from " + mediaFile, (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)jobDir);
        }
        return subtitleFilesURI.toString() + "," + language + "," + this.speechToTextEngine.getEngineName();
    }

    public Job transcribe(URI mediaFile, String language, Boolean translate) throws SpeechToTextServiceException {
        try {
            logger.debug("Creating speechToText service job");
            List<String> jobArguments = Arrays.asList(mediaFile.toString(), language, translate.toString());
            return this.serviceRegistry.createJob("org.opencastproject.speechtotext", OPERATION, jobArguments, Float.valueOf(this.jobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SpeechToTextServiceException((Throwable)e);
        }
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference(name="SpeechToTextEngine", target="(enginetype=whisper)")
    public void setSpeechToTextEngine(SpeechToTextEngine engine) {
        this.speechToTextEngine = engine;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry jobManager) {
        this.serviceRegistry = jobManager;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }
}

