/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.sox;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.AudioStream;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.mediapackage.track.AudioStreamImpl;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.sox.api.SoxException;
import org.opencastproject.sox.api.SoxService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Normalize Audio Workflow Operation Handler", "workflow.operation=normalize-audio"})
public class NormalizeAudioWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(NormalizeAudioWorkflowOperationHandler.class);
    public static final String SOX_AONLY_PROFILE = "sox-audio-only.work";
    public static final String SOX_AREPLACE_PROFILE = "sox-audio-replace.work";
    private SoxService soxService = null;
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setSoxService(SoxService soxService) {
        this.soxService = soxService;
    }

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running sox workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.normalize(workflowInstance.getMediaPackage(), workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowOperationResult normalize(MediaPackage src, WorkflowInstance workflowInstance) throws SoxException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException, EncoderException {
        Float targetDecibel;
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetTagsOption = tagsAndFlavors.getTargetTags();
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorsOption = tagsAndFlavors.getSrcFlavors();
        List targetFlavorOption = tagsAndFlavors.getTargetFlavors();
        String targetDecibelString = StringUtils.trimToNull((String)operation.getConfiguration("target-decibel"));
        if (targetDecibelString == null) {
            throw new IllegalArgumentException("target-decibel must be specified");
        }
        boolean forceTranscode = BooleanUtils.toBoolean((String)operation.getConfiguration("force-transcode"));
        try {
            targetDecibel = new Float(targetDecibelString);
        }
        catch (NumberFormatException e1) {
            throw new WorkflowOperationException("Unable to parse target-decibel " + targetDecibelString);
        }
        TrackSelector elementSelector = new TrackSelector();
        if (sourceTagsOption.isEmpty() && sourceFlavorsOption.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        for (MediaPackageElementFlavor flavor : sourceFlavorsOption) {
            elementSelector.addFlavor(flavor);
        }
        for (String tag : sourceTagsOption) {
            elementSelector.addTag(tag);
        }
        MediaPackageElementFlavor targetFlavor = null;
        if (!targetFlavorOption.isEmpty()) {
            targetFlavor = (MediaPackageElementFlavor)targetFlavorOption.get(0);
        }
        Collection elements = elementSelector.select(mediaPackage, false);
        long totalTimeInQueue = 0L;
        ArrayList<URI> cleanupURIs = new ArrayList<URI>();
        HashMap<Job, Track> normalizeJobs = new HashMap<Job, Track>();
        try {
            for (Track track : elements) {
                TrackImpl audioTrack = (TrackImpl)track;
                if (!track.hasAudio()) {
                    logger.info("Skipping audio normalization of '{}', since it contains no audio stream", (Object)track);
                    continue;
                }
                if (track.hasVideo() || forceTranscode) {
                    audioTrack = (TrackImpl)this.extractAudioTrack(track);
                    audioTrack.setAudio(((TrackImpl)track).getAudio());
                    cleanupURIs.add(audioTrack.getURI());
                }
                if (audioTrack.getAudio().size() < 1 || ((AudioStream)audioTrack.getAudio().get(0)).getRmsLevDb() == null) {
                    logger.info("Audio track {} has no RMS Lev dB metadata, analyze it first", (Object)audioTrack);
                    Job analyzeJob = this.soxService.analyze((Track)audioTrack);
                    if (!this.waitForStatus(new Job[]{analyzeJob}).isSuccess()) {
                        throw new WorkflowOperationException("Unable to analyze the audio track " + audioTrack);
                    }
                    audioTrack = (TrackImpl)MediaPackageElementParser.getFromXml((String)analyzeJob.getPayload());
                    cleanupURIs.add(audioTrack.getURI());
                }
                normalizeJobs.put(this.soxService.normalize((Track)audioTrack, targetDecibel), track);
            }
            if (normalizeJobs.isEmpty()) {
                logger.info("No matching tracks found");
                WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
                return workflowOperationResult;
            }
            if (!this.waitForStatus(normalizeJobs.keySet().toArray(new Job[normalizeJobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("One of the normalize jobs did not complete successfully");
            }
            for (Map.Entry entry : normalizeJobs.entrySet()) {
                Job job = (Job)entry.getKey();
                TrackImpl origTrack = (TrackImpl)entry.getValue();
                totalTimeInQueue += job.getQueueTime().longValue();
                if (job.getPayload().length() > 0) {
                    TrackImpl normalizedAudioTrack;
                    TrackImpl resultTrack = normalizedAudioTrack = (TrackImpl)MediaPackageElementParser.getFromXml((String)job.getPayload());
                    if (origTrack.hasVideo() || forceTranscode) {
                        cleanupURIs.add(normalizedAudioTrack.getURI());
                        logger.info("Mux normalized audio track {} to video track {}", (Object)normalizedAudioTrack, (Object)origTrack);
                        Job muxAudioVideo = this.composerService.mux((Track)origTrack, (Track)normalizedAudioTrack, SOX_AREPLACE_PROFILE);
                        if (!this.waitForStatus(new Job[]{muxAudioVideo}).isSuccess()) {
                            throw new WorkflowOperationException("Muxing normalized audio track " + normalizedAudioTrack + " to video container " + origTrack + " failed");
                        }
                        resultTrack = (TrackImpl)MediaPackageElementParser.getFromXml((String)muxAudioVideo.getPayload());
                        this.extendAudioStream(resultTrack, normalizedAudioTrack);
                    }
                    this.adjustFlavorAndTags(targetTagsOption, targetFlavor, (Track)origTrack, (Track)resultTrack);
                    mediaPackage.addDerived((MediaPackageElement)resultTrack, (MediaPackageElement)origTrack);
                    String fileName = this.getFileNameFromElements((MediaPackageElement)origTrack, (MediaPackageElement)resultTrack);
                    resultTrack.setURI(this.workspace.moveTo(resultTrack.getURI(), mediaPackage.getIdentifier().toString(), resultTrack.getIdentifier(), fileName));
                    continue;
                }
                logger.warn("Normalize audio job {} for track {} has no result!", (Object)job, (Object)origTrack);
            }
        }
        finally {
            for (URI uri : cleanupURIs) {
                this.workspace.delete(uri);
            }
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
        logger.debug("Normalize audio operation completed");
        return result;
    }

    private void extendAudioStream(TrackImpl trackToExtend, TrackImpl audioTrackSource) {
        AudioStreamImpl extendStream = (AudioStreamImpl)trackToExtend.getAudio().get(0);
        AudioStream sourceStream = (AudioStream)audioTrackSource.getAudio().get(0);
        extendStream.setPkLevDb(sourceStream.getPkLevDb());
        extendStream.setRmsLevDb(sourceStream.getRmsLevDb());
        extendStream.setRmsPkDb(sourceStream.getRmsPkDb());
    }

    private void adjustFlavorAndTags(List<String> targetTags, MediaPackageElementFlavor targetFlavor, Track origTrack, Track normalized) {
        for (String tag : targetTags) {
            logger.trace("Tagging normalized track with '{}'", (Object)tag);
            normalized.addTag(tag);
        }
        if (targetFlavor != null) {
            String flavorType = targetFlavor.getType();
            String flavorSubtype = targetFlavor.getSubtype();
            if ("*".equals(flavorType)) {
                flavorType = origTrack.getFlavor().getType();
            }
            if ("*".equals(flavorSubtype)) {
                flavorSubtype = origTrack.getFlavor().getSubtype();
            }
            normalized.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
            logger.debug("Normalized track has flavor '{}'", (Object)normalized.getFlavor());
        }
    }

    private Track extractAudioTrack(Track videoTrack) throws WorkflowOperationException, EncoderException, MediaPackageException {
        logger.info("Extract audio stream from track {}", (Object)videoTrack);
        Job job = this.composerService.encode(videoTrack, SOX_AONLY_PROFILE);
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException("Extracting audio track from video track " + videoTrack + " failed");
        }
        return (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
    }
}

