/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.sox;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.sox.api.SoxException;
import org.opencastproject.sox.api.SoxService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Analyze Audio Workflow Operation Handler", "workflow.operation=analyze-audio"})
public class AnalyzeAudioWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeAudioWorkflowOperationHandler.class);
    public static final String SOX_AONLY_PROFILE = "sox-audio-only.work";
    private SoxService soxService = null;
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setSoxService(SoxService soxService) {
        this.soxService = soxService;
    }

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running analyze audio workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.analyze(workflowInstance.getMediaPackage(), workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowOperationResult analyze(MediaPackage src, WorkflowInstance workflow) throws SoxException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException, EncoderException {
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflow, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        boolean forceTranscode = BooleanUtils.toBoolean((String)workflow.getCurrentOperation().getConfiguration("force-transcode"));
        TrackSelector elementSelector = new TrackSelector();
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        List sourceTags = tagsAndFlavors.getSrcTags();
        if (sourceFlavors.isEmpty() && sourceTags.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        for (MediaPackageElementFlavor flavor : sourceFlavors) {
            try {
                elementSelector.addFlavor(flavor);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Source flavor '" + flavor.toString() + "' is malformed");
            }
        }
        for (String tag : sourceTags) {
            elementSelector.addTag(tag);
        }
        Collection elements = elementSelector.select(mediaPackage, false);
        long totalTimeInQueue = 0L;
        ArrayList<URI> cleanupURIs = new ArrayList<URI>();
        HashMap<Job, Track> analyzeJobs = new HashMap<Job, Track>();
        try {
            for (Track track : elements) {
                TrackImpl audioTrack = (TrackImpl)track;
                if (!track.hasAudio()) {
                    logger.info("Skipping audio analysis of '{}', since it contains no audio stream", (Object)track);
                    continue;
                }
                if (track.hasVideo() || forceTranscode) {
                    audioTrack = (TrackImpl)this.extractAudioTrack(track);
                    audioTrack.setAudio(((TrackImpl)track).getAudio());
                    cleanupURIs.add(audioTrack.getURI());
                }
                analyzeJobs.put(this.soxService.analyze((Track)audioTrack), track);
            }
            if (analyzeJobs.isEmpty()) {
                logger.info("No matching tracks found");
                WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
                return workflowOperationResult;
            }
            if (!this.waitForStatus(analyzeJobs.keySet().toArray(new Job[analyzeJobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("One of the analyze jobs did not complete successfully");
            }
            for (Map.Entry entry : analyzeJobs.entrySet()) {
                Job job = (Job)entry.getKey();
                TrackImpl origTrack = (TrackImpl)entry.getValue();
                totalTimeInQueue += job.getQueueTime().longValue();
                if (job.getPayload().length() > 0) {
                    TrackImpl analyzed = (TrackImpl)MediaPackageElementParser.getFromXml((String)job.getPayload());
                    origTrack.setAudio(analyzed.getAudio());
                    continue;
                }
                logger.warn("Analyze audio job {} for track {} has no result!", (Object)job, (Object)origTrack);
            }
        }
        finally {
            for (URI uri : cleanupURIs) {
                this.workspace.delete(uri);
            }
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
        logger.debug("Analyze audio operation completed");
        return result;
    }

    private Track extractAudioTrack(Track videoTrack) throws WorkflowOperationException, EncoderException, MediaPackageException {
        logger.info("Extract audio stream from track {}", (Object)videoTrack);
        Job job = this.composerService.encode(videoTrack, SOX_AONLY_PROFILE);
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException("Extracting audio track from video track " + videoTrack + " failed");
        }
        return (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

