/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.sox.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.sox.api.SoxException;
import org.opencastproject.sox.api.SoxService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SoxService.class}, property={"service.description=SoX Remote Service Proxy"})
public class SoxServiceRemoteImpl
extends RemoteBase
implements SoxService {
    private static final Logger logger = LoggerFactory.getLogger(SoxServiceRemoteImpl.class);

    public SoxServiceRemoteImpl() {
        super("org.opencastproject.sox");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job analyze(Track sourceAudioTrack) throws MediaPackageException, SoxException {
        HttpPost post = new HttpPost("/analyze");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceAudioTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceAudioTrack)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new SoxException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Analyzing audio {} on a remote analysis server", (Object)sourceAudioTrack);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new SoxException("Unable to analyze audio of element '" + sourceAudioTrack + "' using a remote analysis service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new SoxException("Unable to analyze audio of element '" + sourceAudioTrack + "' using a remote analysis service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job normalize(Track sourceAudioTrack, Float targetRmsLevDb) throws MediaPackageException, SoxException {
        HttpPost post = new HttpPost("/normalize");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceAudioTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceAudioTrack)));
            params.add(new BasicNameValuePair("targetRmsLevDb", targetRmsLevDb.toString()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new SoxException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Normalizing audio {} on a remote audio processing server", (Object)sourceAudioTrack);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new SoxException("Unable to normalize audio of element '" + sourceAudioTrack + "' using a remote audio processing service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new SoxException("Unable to normalize audio of element '" + sourceAudioTrack + "' using a remote audio processing service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

