/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.sox.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.AudioStream;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.mediapackage.track.AudioStreamImpl;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.sox.api.SoxException;
import org.opencastproject.sox.api.SoxService;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Option;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SoxService.class, ManagedService.class}, property={"service.description=Sox audio processing service"})
public class SoxServiceImpl
extends AbstractJobProducer
implements SoxService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(SoxServiceImpl.class);
    public static final String SOX_BINARY_DEFAULT = "sox";
    public static final String CONFIG_SOX_PATH = "org.opencastproject.sox.path";
    public static final float DEFAULT_ANALYZE_JOB_LOAD = 0.2f;
    public static final String ANALYZE_JOB_LOAD_KEY = "job.load.analyze";
    private float analyzeJobLoad = 0.2f;
    public static final float DEFAULT_NORMALIZE_JOB_LOAD = 0.2f;
    public static final String NORMALIZE_JOB_LOAD_KEY = "job.load.normalize";
    private float normalizeJobLoad = 0.2f;
    public static final String COLLECTION = "sox";
    private Workspace workspace = null;
    private ServiceRegistry serviceRegistry;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    private String binary = "sox";

    public SoxServiceImpl() {
        super("org.opencastproject.sox");
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating sox service");
        super.activate(cc);
        String path = cc.getBundleContext().getProperty(CONFIG_SOX_PATH);
        if (path == null) {
            logger.debug("DEFAULT org.opencastproject.sox.path: sox");
        } else {
            this.binary = path;
            logger.debug("SoX config binary: {}", (Object)path);
        }
    }

    public Job analyze(Track sourceAudioTrack) throws MediaPackageException, SoxException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.sox", Operation.Analyze.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceAudioTrack)), Float.valueOf(this.analyzeJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SoxException("Unable to create a job", (Throwable)e);
        }
    }

    public Job normalize(Track sourceAudioTrack, Float targetRmsLevDb) throws MediaPackageException, SoxException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.sox", Operation.Normalize.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceAudioTrack), targetRmsLevDb.toString()), Float.valueOf(this.normalizeJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SoxException("Unable to create a job", (Throwable)e);
        }
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            String serialized;
            op = Operation.valueOf(operation);
            TrackImpl audioTrack = null;
            switch (op) {
                case Analyze: {
                    audioTrack = (TrackImpl)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    serialized = (String)this.analyze(job, (Track)audioTrack).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                    break;
                }
                case Normalize: {
                    audioTrack = (TrackImpl)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    Float targetRmsLevDb = new Float((String)arguments.get(1));
                    serialized = (String)this.normalize(job, audioTrack, targetRmsLevDb).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
                }
            }
            return serialized;
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + op + "'", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + op + "'", (Throwable)e);
        }
    }

    protected Option<Track> analyze(Job job, Track audioTrack) throws SoxException {
        if (!audioTrack.hasAudio()) {
            throw new SoxException("No audio stream available");
        }
        if (audioTrack.hasVideo()) {
            throw new SoxException("It must not have a video stream");
        }
        try {
            File audioFile;
            try {
                audioFile = this.workspace.get(audioTrack.getURI());
            }
            catch (NotFoundException e) {
                throw new SoxException("Requested audio track " + audioTrack + " is not found");
            }
            catch (IOException e) {
                throw new SoxException("Unable to access audio track " + audioTrack);
            }
            logger.info("Analyzing audio track {}", (Object)audioTrack.getIdentifier());
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.binary);
            command.add(audioFile.getAbsolutePath());
            command.add("-n");
            command.add("remix");
            command.add("-");
            command.add("stats");
            List<String> analyzeResult = this.launchSoxProcess(command);
            return Option.some((Object)this.addAudioMetadata(audioTrack, analyzeResult));
        }
        catch (Exception e) {
            logger.warn("Error analyzing {}: {}", (Object)audioTrack, (Object)e.getMessage());
            if (e instanceof SoxException) {
                throw (SoxException)e;
            }
            throw new SoxException((Throwable)e);
        }
    }

    private Track addAudioMetadata(Track audioTrack, List<String> metadata) {
        TrackImpl track = (TrackImpl)audioTrack;
        List audio = track.getAudio();
        if (audio.size() == 0) {
            audio.add(new AudioStreamImpl());
            logger.info("No audio streams found created new audio stream");
        }
        AudioStreamImpl audioStream = (AudioStreamImpl)audio.get(0);
        if (audio.size() > 1) {
            logger.info("Multiple audio streams found, take first audio stream {}", (Object)audioStream);
        }
        for (String value : metadata) {
            if (value.startsWith("Pk lev dB")) {
                Float pkLevDb = new Float(StringUtils.substringAfter((String)value, (String)"Pk lev dB").trim());
                audioStream.setPkLevDb(pkLevDb);
                continue;
            }
            if (value.startsWith("RMS lev dB")) {
                Float rmsLevDb = new Float(StringUtils.substringAfter((String)value, (String)"RMS lev dB").trim());
                audioStream.setRmsLevDb(rmsLevDb);
                continue;
            }
            if (!value.startsWith("RMS Pk dB")) continue;
            Float rmsPkDb = new Float(StringUtils.substringAfter((String)value, (String)"RMS Pk dB").trim());
            audioStream.setRmsPkDb(rmsPkDb);
        }
        return track;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> launchSoxProcess(List<String> command) throws SoxException {
        ArrayList<String> arrayList;
        Process process = null;
        BufferedReader in = null;
        try {
            logger.info("Start sox process {}", command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            process = pb.start();
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            process.waitFor();
            String line = null;
            ArrayList<String> stats = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                logger.info(line);
                stats.add(line);
            }
            if (process.exitValue() != 0) {
                throw new SoxException("Sox process failed with error code: " + process.exitValue());
            }
            logger.info("Sox process finished");
            arrayList = stats;
        }
        catch (IOException e) {
            try {
                throw new SoxException("Could not start sox process: " + command + "\n" + e.getMessage());
                catch (InterruptedException e2) {
                    throw new SoxException("Could not start sox process: " + command + "\n" + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(in);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)in);
        return arrayList;
    }

    private Option<Track> normalize(Job job, TrackImpl audioTrack, Float targetRmsLevDb) throws SoxException {
        FileInputStream in;
        URI returnURL;
        List<String> normalizeResult;
        File normalizedFile;
        String targetTrackId;
        block14: {
            File audioFile;
            if (!audioTrack.hasAudio()) {
                throw new SoxException("No audio stream available");
            }
            if (audioTrack.hasVideo()) {
                throw new SoxException("It must not have a video stream");
            }
            if (audioTrack.getAudio().size() < 1) {
                throw new SoxException("No audio stream metadata available");
            }
            if (((AudioStream)audioTrack.getAudio().get(0)).getRmsLevDb() == null) {
                throw new SoxException("No RMS Lev dB metadata available");
            }
            targetTrackId = IdImpl.fromUUID().toString();
            Float rmsLevDb = ((AudioStream)audioTrack.getAudio().get(0)).getRmsLevDb();
            try {
                audioFile = this.workspace.get(audioTrack.getURI());
            }
            catch (NotFoundException e) {
                throw new SoxException("Requested audio track " + audioTrack + " is not found");
            }
            catch (IOException e) {
                throw new SoxException("Unable to access audio track " + audioTrack);
            }
            String outDir = audioFile.getAbsoluteFile().getParent();
            String outFileName = FilenameUtils.getBaseName((String)audioFile.getName()) + "_" + UUID.randomUUID().toString();
            String suffix = "-norm." + FilenameUtils.getExtension((String)audioFile.getName());
            normalizedFile = new File(outDir, outFileName + suffix);
            logger.info("Normalizing audio track {} to {}", (Object)audioTrack.getIdentifier(), (Object)targetTrackId);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.binary);
            command.add(audioFile.getAbsolutePath());
            command.add(normalizedFile.getAbsolutePath());
            command.add("remix");
            command.add("-");
            command.add("gain");
            if (targetRmsLevDb.floatValue() > rmsLevDb.floatValue()) {
                command.add("-l");
            }
            command.add(new Float(targetRmsLevDb.floatValue() - rmsLevDb.floatValue()).toString());
            command.add("stats");
            normalizeResult = this.launchSoxProcess(command);
            if (normalizedFile.length() == 0L) {
                throw new SoxException("Normalization failed: Output file is empty!");
            }
            returnURL = null;
            in = null;
            try {
                in = new FileInputStream(normalizedFile);
                returnURL = this.workspace.putInCollection("sox", job.getId() + "." + FilenameUtils.getExtension((String)normalizedFile.getAbsolutePath()), (InputStream)in);
                logger.info("Copied the normalized file to the workspace at {}", (Object)returnURL);
                if (normalizedFile.delete()) {
                    logger.info("Deleted the local copy of the normalized file at {}", (Object)normalizedFile.getAbsolutePath());
                    break block14;
                }
                logger.warn("Unable to delete the normalized output at {}", (Object)normalizedFile);
            }
            catch (Exception e) {
                try {
                    throw new SoxException("Unable to put the normalized file into the workspace", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    FileSupport.deleteQuietly((File)normalizedFile);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        FileSupport.deleteQuietly((File)normalizedFile);
        Track normalizedTrack = (Track)audioTrack.clone();
        normalizedTrack.setURI(returnURL);
        normalizedTrack.setIdentifier(targetTrackId);
        normalizedTrack = this.addAudioMetadata(normalizedTrack, normalizeResult);
        return Option.some((Object)normalizedTrack);
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.analyzeJobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)ANALYZE_JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
        this.normalizeJobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)NORMALIZE_JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
    }

    private static enum Operation {
        Analyze,
        Normalize;

    }
}

