/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.entity.media.param;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.param.SmilMediaParamImpl;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;

@XmlRootElement(name="paramGroup")
public class SmilMediaParamGroupImpl
extends SmilObjectImpl
implements SmilMediaParamGroup {
    private List<SmilMediaParam> params = new LinkedList<SmilMediaParam>();

    @Override
    public List<SmilMediaParam> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    @XmlElementRef(type=SmilMediaParamImpl.class)
    protected List<SmilMediaParam> getParamsList() {
        return this.params;
    }

    protected void setParamsList(List<SmilMediaParam> params) {
        this.params = params;
    }

    @Override
    protected String getIdPrefix() {
        return "pg";
    }

    public SmilMediaParam getParamByName(String name) {
        for (SmilMediaParam p : this.params) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public SmilMediaParam addParam(String name, String value) {
        SmilMediaParam param = this.getParamByName(name);
        if (param == null) {
            param = new SmilMediaParamImpl(name, value);
        }
        this.params.add(param);
        return param;
    }

    public void addParam(SmilMediaParam param) {
        if (param == null) {
            return;
        }
        SmilObject p = this.getElementOrNull(param.getId());
        if (p != null && p instanceof SmilMediaParam) {
            ((SmilMediaParamImpl)p).setName(param.getName());
            ((SmilMediaParamImpl)p).setValue(param.getValue());
        } else {
            this.params.add(param);
        }
    }

    public void removeParamByName(String name) {
        this.removeParam(this.getParamByName(name));
    }

    public void removeParam(SmilMediaParam param) {
        if (param == null) {
            return;
        }
        if (this.params.contains(param)) {
            this.params.remove(param);
        }
    }

    @Override
    public SmilObject removeElement(String elementId) {
        SmilObject child = null;
        for (SmilObject smilObject : this.params) {
            if (smilObject.getId().equals(elementId)) {
                child = smilObject;
                break;
            }
            SmilObject removed = ((SmilObjectImpl)smilObject).removeElement(elementId);
            if (removed == null) continue;
            return removed;
        }
        if (child != null) {
            this.params.remove(child);
        }
        return child;
    }

    @Override
    public SmilObject getElementOrNull(String elementId) {
        if (this.getId().equals(elementId)) {
            return this;
        }
        for (SmilMediaParam param : this.getParams()) {
            SmilObject element = ((SmilMediaParamImpl)param).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public void putAllChilds(List<SmilObject> elements) {
        for (SmilObject smilObject : this.getParams()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
    }
}

