/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.entity.media.element;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.SmilMediaObjectImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaAudioImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaReferenceImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaVideoImpl;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.smil.entity.media.param.SmilMediaParamImpl;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;

@XmlSeeAlso(value={SmilMediaAudioImpl.class, SmilMediaVideoImpl.class, SmilMediaReferenceImpl.class})
public abstract class SmilMediaElementImpl
extends SmilMediaObjectImpl
implements SmilMediaElement {
    private URI src;
    private String clipBegin;
    private String clipEnd;
    private String paramGroupId;
    private List<SmilMediaParam> params = new LinkedList<SmilMediaParam>();

    private SmilMediaElementImpl() {
        this(null, null, null);
    }

    public SmilMediaElementImpl(URI src, String clipBegin, String clipEnd) {
        this(src, clipBegin, clipEnd, null);
    }

    public SmilMediaElementImpl(URI src, String clipBegin, String clipEnd, String paramGroupId) {
        this.src = src;
        this.clipBegin = clipBegin;
        this.clipEnd = clipEnd;
        this.paramGroupId = paramGroupId;
    }

    public SmilMediaElementImpl(URI src, long clipBeginMS, long clipEndMS) {
        this(src, clipBeginMS + "ms", clipEndMS + "ms", null);
    }

    public SmilMediaElementImpl(URI src, long clipBeginMS, long clipEndMS, String paramGroupId) {
        this(src, clipBeginMS + "ms", clipEndMS + "ms", paramGroupId);
    }

    @Override
    @XmlAttribute(name="src")
    public URI getSrc() {
        return this.src;
    }

    public void setSrc(URI src) {
        this.src = src;
    }

    @Override
    @XmlAttribute(name="clipBegin")
    public String getClipBegin() {
        return this.clipBegin;
    }

    @Override
    public long getClipBeginMS() throws SmilException {
        return this.convertTimeToMS(this.clipBegin);
    }

    public void setClipBegin(String clipBegin) {
        this.clipBegin = clipBegin;
    }

    @Override
    @XmlAttribute(name="clipEnd")
    public String getClipEnd() {
        return this.clipEnd;
    }

    @Override
    public long getClipEndMS() throws SmilException {
        return this.convertTimeToMS(this.clipEnd);
    }

    public void setClipEnd(String clipEnd) {
        this.clipEnd = clipEnd;
    }

    @Override
    @XmlAttribute(name="paramGroup")
    public String getParamGroup() {
        return this.paramGroupId;
    }

    public void setParamGroup(String paramGroupId) {
        this.paramGroupId = paramGroupId;
    }

    @Override
    public List<SmilMediaParam> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    @XmlElementRef(type=SmilMediaParamImpl.class)
    protected List<SmilMediaParam> getParamsList() {
        return this.params;
    }

    protected void setParamsList(List<SmilMediaParam> params) {
        this.params = params;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public abstract SmilMediaElement.MediaType getMediaType();

    @Override
    public SmilObject getElementOrNull(String elementId) {
        if (this.getId().equals(elementId)) {
            return this;
        }
        for (SmilMediaParam media : this.getParams()) {
            SmilObject element = ((SmilMediaParamImpl)media).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public SmilObject removeElement(String elementId) {
        SmilObject child = null;
        for (SmilObject smilObject : this.params) {
            if (smilObject.getId().equals(elementId)) {
                child = smilObject;
                break;
            }
            SmilObject removed = ((SmilObjectImpl)smilObject).removeElement(elementId);
            if (removed == null) continue;
            return removed;
        }
        if (child != null) {
            this.params.remove(child);
        }
        return child;
    }

    protected long convertTimeToMS(String timeUnit) throws SmilException {
        TimeUnit unit;
        long time = -1L;
        if (timeUnit.endsWith("ms")) {
            unit = TimeUnit.MILLISECONDS;
            time = Long.parseLong(timeUnit.replace("ms", "").trim());
        } else if (timeUnit.endsWith("s")) {
            unit = TimeUnit.SECONDS;
            time = (long)Double.parseDouble(timeUnit.replace("s", "").trim());
        } else {
            throw new SmilException("failed parsing time unit");
        }
        return unit.toMillis(time);
    }

    @Override
    public void putAllChilds(List<SmilObject> elements) {
        for (SmilObject smilObject : this.getParams()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
    }
}

