/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.entity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.SmilBody;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.SmilMediaObjectImpl;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.SmilMediaContainerImpl;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;

@XmlRootElement(name="body")
public class SmilBodyImpl
extends SmilObjectImpl
implements SmilBody {
    private List<SmilMediaObject> mediaElements = new LinkedList<SmilMediaObject>();

    @Override
    public List<SmilMediaObject> getMediaElements() {
        return Collections.unmodifiableList(this.mediaElements);
    }

    @XmlElementRef(type=SmilMediaObjectImpl.class)
    protected List<SmilMediaObject> getMediaObjects() {
        return this.mediaElements;
    }

    protected void setMediaObjects(List<SmilMediaObject> mediaElements) {
        this.mediaElements = mediaElements;
    }

    @Override
    protected String getIdPrefix() {
        return "b";
    }

    public void addMediaElement(SmilMediaObject mediaObject, String parentId) throws SmilException {
        if (!this.getId().equals(parentId)) {
            for (SmilMediaObject element : this.mediaElements) {
                if (!element.isContainer() || !element.getId().equals(parentId) && !((SmilMediaContainer)element).isParentOf(parentId)) continue;
                ((SmilMediaContainerImpl)element).addMediaObject(mediaObject, parentId);
                return;
            }
            throw new SmilException("There is no element with id " + parentId);
        }
        this.mediaElements.add(mediaObject);
    }

    @Override
    public SmilObject removeElement(String elementId) {
        SmilMediaObject child = null;
        for (SmilMediaObject element : this.mediaElements) {
            if (element.getId().equals(elementId)) {
                child = element;
                break;
            }
            SmilObject removed = ((SmilObjectImpl)((Object)element)).removeElement(elementId);
            if (removed == null) continue;
            return removed;
        }
        if (child != null) {
            this.mediaElements.remove(child);
        }
        return child;
    }

    public void clear() {
        this.mediaElements.clear();
    }

    @Override
    public SmilObject getElementOrNull(String elementId) {
        if (this.getId().equals(elementId)) {
            return this;
        }
        for (SmilMediaObject media : this.getMediaElements()) {
            SmilObject element = ((SmilMediaObjectImpl)media).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public void putAllChilds(List<SmilObject> elements) {
        for (SmilObject smilObject : this.getMediaElements()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
    }
}

