/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.util;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributionPathUtils {
    private static final Logger logger = LoggerFactory.getLogger(DistributionPathUtils.class);
    private static final String CONFIG_DOWNLOAD_ROOT = "org.opencastproject.download.directory";
    private static final String CONFIG_DOWNLOAD_URL = "org.opencastproject.download.url";

    private DistributionPathUtils() {
    }

    public static String getDownloadPath(ComponentContext componentContext) {
        if (componentContext == null || componentContext.getBundleContext() == null) {
            return null;
        }
        BundleContext bundleContext = componentContext.getBundleContext();
        String downloadDir = StringUtils.trimToNull((String)bundleContext.getProperty(CONFIG_DOWNLOAD_ROOT));
        if (downloadDir != null && new File(downloadDir).isDirectory()) {
            logger.debug("Found local distribution directory at {}", (Object)downloadDir);
            return downloadDir;
        }
        return null;
    }

    public static String getDownloadUrl(ComponentContext componentContext) {
        if (componentContext == null || componentContext.getBundleContext() == null) {
            return null;
        }
        BundleContext bundleContext = componentContext.getBundleContext();
        String downloadUrl = StringUtils.trimToNull((String)bundleContext.getProperty(CONFIG_DOWNLOAD_URL));
        if (downloadUrl != null) {
            logger.debug("Local distribution URL is {}", (Object)downloadUrl);
            return downloadUrl;
        }
        return null;
    }

    public static File getLocalFile(String localPath, String downloadUrl, String organizationId, URI uri) {
        if (localPath == null || organizationId == null || !uri.toString().startsWith(downloadUrl)) {
            return null;
        }
        File file = Paths.get(localPath, uri.toString().substring(downloadUrl.length())).toFile();
        if (file.isFile()) {
            logger.debug("Converted {} to local file at {}", (Object)uri, (Object)file);
            return file;
        }
        logger.debug("Local file for {} not available. {} does not exist.", (Object)uri, (Object)file);
        return null;
    }
}

