/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.opencastproject.security.api.GroupProvider;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.userdirectory.api.AAIRoleProvider;
import org.opencastproject.userdirectory.api.UserReferenceProvider;

public class JWTRoleProvider
implements AAIRoleProvider,
GroupProvider {
    private final SecurityService securityService;
    private final UserReferenceProvider userReferenceProvider;

    public JWTRoleProvider(SecurityService securityService, UserReferenceProvider userReferenceProvider) {
        this.securityService = securityService;
        this.userReferenceProvider = userReferenceProvider;
    }

    public Iterator<Role> getRoles() {
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
        roles.add(new JaxbRole(organization.getAnonymousRole(), organization));
        roles.addAll(this.securityService.getUser().getRoles());
        return roles.iterator();
    }

    public List<Role> getRolesForUser(String userName) {
        ArrayList<Role> roles = new ArrayList<Role>();
        User user = this.userReferenceProvider.loadUser(userName);
        if (user != null) {
            roles.addAll(user.getRoles());
        }
        return roles;
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        HashSet<Role> foundRoles = new HashSet<Role>();
        Iterator<Role> it = this.getRoles();
        while (it.hasNext()) {
            Role role = it.next();
            if (!this.like(role.getName(), query) && !this.like(role.getDescription(), query)) continue;
            foundRoles.add(role);
        }
        return this.offsetLimitCollection(offset, limit, foundRoles).iterator();
    }

    private <T> HashSet<T> offsetLimitCollection(int offset, int limit, HashSet<T> entries) {
        HashSet<T> result = new HashSet<T>();
        int i = 0;
        for (T entry : entries) {
            if (limit != 0 && result.size() >= limit) break;
            if (i >= offset) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }

    public List<Role> getRolesForGroup(String groupName) {
        return null;
    }
}

